/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseDocumentProxyTest;
import de.jakop.lotus.domingo.DBaseDocument;
import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.util.GregorianDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public final class DocumentProxyTest
extends BaseDocumentProxyTest {
    public DocumentProxyTest(String name) {
        super(name);
    }

    public void testEquals() {
        DBaseDocument anotherOne;
        System.out.println("-> testEquals");
        DDocument doc = this.getDatabase().createDocument();
        doc.save();
        DDocument receivedDoc = this.getDatabase().getDocumentByUNID(doc.getUniversalID());
        if (!this.isDIIOP()) {
            DocumentProxyTest.assertEquals((String)"Documents should be equal but are not.", (Object)doc, (Object)receivedDoc);
        }
        DocumentProxyTest.assertTrue((String)"Documents should NOT be equal but are.", (!doc.equals(anotherOne = this.createDBaseDocument()) ? 1 : 0) != 0);
        doc.remove(true);
    }

    public void testSave() {
        System.out.println("-> testSave");
        DDocument doc = this.getDatabase().createDocument();
        String someValue = "someValueForTestSave";
        doc.appendItemValue(this.getItemName(), someValue);
        doc.save();
        String uniID = doc.getUniversalID();
        DDocument received = this.getDatabase().getDocumentByUNID(uniID);
        String receivedValue = received.getItemValueString(this.getItemName());
        DocumentProxyTest.assertEquals((String)"The Document received from the database should contain an item, but does not.", (String)someValue, (String)receivedValue);
        if (!this.isDIIOP()) {
            DocumentProxyTest.assertTrue((String)"The Document received should be equal to the previously saved one.", (boolean)doc.equals(received));
        }
        doc.remove(true);
    }

    public void testSaveBoolean() {
        System.out.println("-> testSaveBoolean");
        DDocument doc = this.getDatabase().createDocument();
        String someValue = "someValueForTestSave";
        doc.appendItemValue(this.getItemName(), someValue);
        boolean saved = doc.save(true);
        DocumentProxyTest.assertTrue((String)"The save action should work properly.", (boolean)saved);
        doc.appendItemValue(this.getItemName() + this.getItemName(), someValue);
        saved = doc.save(false);
        DocumentProxyTest.assertTrue((String)"The unforced save action should work properly.", (boolean)saved);
        String uniID = doc.getUniversalID();
        DDocument received = this.getDatabase().getDocumentByUNID(uniID);
        DocumentProxyTest.assertNotNull((String)"The received document should exist.", (Object)received);
        String receivedValue = received.getItemValueString(this.getItemName());
        DocumentProxyTest.assertEquals((String)"Document should contain an item, but does not.", (String)someValue, (String)receivedValue);
        String receivedValue1 = received.getItemValueString(this.getItemName() + this.getItemName());
        DocumentProxyTest.assertEquals((String)" Document should contain a second item, but does not.", (String)someValue, (String)receivedValue1);
        if (!this.isDIIOP()) {
            DocumentProxyTest.assertTrue((String)"Document should be equal to the previously saved one.", (boolean)doc.equals(received));
        }
        doc.remove(true);
    }

    public void testSaveBooleanBoolean() {
        System.out.println("-> testSaveBooleanBoolean");
        DDocument doc = this.getDatabase().createDocument();
        String someValue = "someValueForTestSave";
        doc.appendItemValue(this.getItemName(), someValue);
        boolean saved = doc.save(true, false);
        DocumentProxyTest.assertTrue((String)"The save action should work properly.", (boolean)saved);
        doc.appendItemValue(this.getItemName() + this.getItemName(), someValue);
        saved = doc.save(true, true);
        DocumentProxyTest.assertTrue((String)"The unforced save action should work properly.", (boolean)saved);
        String uniID = doc.getUniversalID();
        DDocument received = this.getDatabase().getDocumentByUNID(uniID);
        DocumentProxyTest.assertNotNull((String)"The received document should exist.", (Object)received);
        String receivedValue = received.getItemValueString(this.getItemName());
        DocumentProxyTest.assertEquals((String)"Document should contain an item, but does not.", (String)someValue, (String)receivedValue);
        String receivedValue1 = received.getItemValueString(this.getItemName() + this.getItemName());
        DocumentProxyTest.assertEquals((String)"Document should contain a second item, but does not.", (String)someValue, (String)receivedValue1);
        if (!this.isDIIOP()) {
            DocumentProxyTest.assertTrue((String)"Document should be equal to the previously saved one.", (boolean)doc.equals(received));
        }
        doc.remove(true);
    }

    public void testGeneralInfo() {
        System.out.println("-> testGeneralInfo");
        DDocument doc = this.getDatabase().createDocument();
        DocumentProxyTest.assertTrue((String)"Document should be new (not saved)", (boolean)doc.isNewNote());
        doc.save();
        DocumentProxyTest.assertTrue((String)("Document should NOT be new (saved) (" + ((Object)((Object)this)).getClass().getName() + ")"), (!doc.isNewNote() ? 1 : 0) != 0);
        String noteId = doc.getNoteID();
        String received = this.getDatabase().getDocumentByUNID(doc.getUniversalID()).getNoteID();
        DocumentProxyTest.assertTrue((String)"The NoteID of a saved one differs from the direct accessible one.", (boolean)noteId.equals(received));
        doc.remove(true);
    }

    public void testResponses() {
        System.out.println("-> testResponses");
        DDocument doc = this.getDatabase().createDocument();
        doc.save();
        DocumentProxyTest.assertTrue((String)"Document should be no response.", (!doc.isResponse() ? 1 : 0) != 0);
        Iterator it = doc.getResponses();
        DocumentProxyTest.assertTrue((String)"Document should have no responses.", (!it.hasNext() ? 1 : 0) != 0);
        DDocument parent = this.getDatabase().createDocument();
        parent.save();
        doc.makeResponse(parent);
        DocumentProxyTest.assertTrue((String)"Document should be a response.", (boolean)doc.isResponse());
        parent.save();
        doc.save();
        it = parent.getResponses();
        DocumentProxyTest.assertTrue((String)"Document should have responses.", (boolean)it.hasNext());
    }

    public void testParents() {
        System.out.println("-> testParents");
        DDocument doc1 = this.getDatabase().createDocument();
        DDocument doc2 = this.getDatabase().createDocument();
        doc1.save();
        doc2.save();
        DocumentProxyTest.assertNull((String)"Document has a parent, but should have NONE.", (Object)doc1.getParentDocument());
        DDocument parent = this.getDatabase().createDocument();
        parent.save();
        doc1.makeResponse(parent);
        doc2.makeResponse(parent);
        doc1.save();
        doc2.save();
        DDocument parent1 = doc1.getParentDocument();
        DocumentProxyTest.assertTrue((String)"Document has no parent, but should have one.", (parent1 != null && parent1.equals(parent) ? 1 : 0) != 0);
        DDocument parent2 = doc2.getParentDocument();
        DocumentProxyTest.assertTrue((String)"Document has no parent, but should have one.", (parent2 != null && parent2.equals(parent) ? 1 : 0) != 0);
        DocumentProxyTest.assertTrue((String)"Parent has wrong UniveralID.", (boolean)parent2.getUniversalID().equals(parent.getUniversalID()));
        doc1.remove(true);
        doc2.remove(true);
        parent.remove(true);
    }

    public void testCopyToDatabase() {
        DDocument doc = this.getDatabase().createDocument();
        String itemValue = "some really unimportant text";
        doc.appendItemValue(this.getItemName(), itemValue);
        doc.save();
        DDatabase newDB = this.getSession().createDatabase(this.getServerName(), "testCopyToDatabase_" + System.currentTimeMillis() + ".nsf");
        doc.copyToDatabase(newDB);
        Iterator it = newDB.getAllDocuments();
        boolean ok = false;
        while (it.hasNext()) {
            DDocument doc1 = (DDocument)it.next();
            if (!itemValue.equals(doc1.getItemValueString(this.getItemName()))) continue;
            ok = true;
        }
        DocumentProxyTest.assertTrue((String)"The document is NOT in the new Database", (boolean)ok);
        doc.remove(true);
        newDB.remove();
    }

    public void testSendString() {
        System.out.println("-> testSendString");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.save();
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSetSaveMessageOnSaveTrue() {
        System.out.println("-> testSaveMessageOnSend");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.setSaveMessageOnSend(true);
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSetSaveMessageOnSaveFalse() {
        System.out.println("-> testSaveMessageOnSend");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.setSaveMessageOnSend(false);
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSetEncryptOnSendTrue() {
        System.out.println("-> testSetEncryptOnSendTrue");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.setEncryptOnSend(false);
        doc.save();
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSetEncryptOnSendFalse() {
        System.out.println("-> testSetEncryptOnSendFalse");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.setEncryptOnSend(false);
        doc.save();
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSetSignOnSendTrue() {
        System.out.println("-> testSetSignOnSendTrue");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.setSignOnSend(false);
        doc.save();
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSetSignOnSendFalse() {
        System.out.println("-> testSetSignOnSendFalse");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.setSignOnSend(false);
        doc.save();
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSign() {
        System.out.println("-> testSign");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo - please delete this mail.");
        doc.sign();
        doc.save();
        String user = this.getSession().getUserName();
        doc.send(user);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testSendList() {
        System.out.println("-> testSendString");
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Subject", "# Mailing test from Domingo tests - please delete this mail.");
        doc.save();
        String user = this.getSession().getUserName();
        ArrayList<String> list = new ArrayList<String>();
        list.add(user);
        doc.send(list);
        DocumentProxyTest.assertNotNull((String)"Document not sent. Maybe disconnected from mail server?.", (Object)doc.getItemValueDate("PostedDate"));
        doc.remove(true);
    }

    public void testDateTimeValues1() {
        System.out.println("-> testDateTimeValues");
        DDocument doc = this.getDatabase().createDocument();
        try {
            GregorianDate date1 = new GregorianDate(2004, 1, 3);
            GregorianDate date2 = new GregorianDate(2007, 6, 5);
            doc.appendItemValue("date1", (Calendar)date1);
            doc.appendItemValue("date2", (Calendar)date2);
            List value1 = doc.getItemValue("date1");
            doc.save();
            List value2 = doc.getItemValue("date2");
            Calendar result1 = (Calendar)value1.get(0);
            Calendar result2 = (Calendar)value2.get(0);
            result1.getTime();
            result2.getTime();
            System.out.println(date1);
            System.out.println(result1);
            System.out.println(date2);
            System.out.println(result2);
            DocumentProxyTest.assertEquals((String)"Got wrong date from document.", (Object)date2, (Object)result2);
            DocumentProxyTest.assertEquals((String)"Got wrong date from document.", (Object)date1, (Object)result1);
        }
        catch (Exception e) {
            DocumentProxyTest.fail((String)"Unexpected Exception. Maybe a recycle problem?");
            e.printStackTrace();
        }
        doc.remove(true);
    }

    public void testDateTimeValues2() {
        System.out.println("-> testDateTimeValues");
        DDocument doc = this.getDatabase().createDocument();
        try {
            GregorianDate date1 = new GregorianDate(2004, 2, 11);
            GregorianDate date2 = new GregorianDate(2007, 7, 21);
            doc.appendItemValue("date1", (Calendar)date1);
            doc.appendItemValue("date2", (Calendar)date2);
            List value1 = doc.getItemValue("date1");
            doc.save();
            List value2 = doc.getItemValue("date2");
            Calendar result1 = (Calendar)value1.get(0);
            Calendar result2 = (Calendar)value2.get(0);
            result1.getTime();
            result2.getTime();
            System.out.println(date1);
            System.out.println(result1);
            System.out.println(date2);
            System.out.println(result2);
            DocumentProxyTest.assertEquals((String)"Got wrong date from document.", (Object)date2, (Object)result2);
            DocumentProxyTest.assertEquals((String)"Got wrong date from document.", (Object)date1, (Object)result1);
        }
        catch (Exception e) {
            DocumentProxyTest.fail((String)"Unexpected Exception. Maybe a recycle problem?");
            e.printStackTrace();
        }
        doc.remove(true);
    }

    protected DBaseDocument createDBaseDocument() {
        return this.getDatabase().createDocument();
    }

    protected void setUpConcreteTest() {
    }
}

