/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseProxyTest;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DEmbeddedObject;
import de.jakop.lotus.domingo.DRichTextItem;
import java.io.File;
import java.io.IOException;

public final class EmbeddedObjectProxyTest
extends BaseProxyTest {
    private String itemName;
    private DDocument doc;
    private File attachFile;
    private DRichTextItem rTitem;

    public EmbeddedObjectProxyTest(String name) {
        super(name);
    }

    public void testExtractFile() {
        System.out.println("-> EmbeddedObjectProxy.testExtractFile");
        String path = this.attachFile.getAbsolutePath();
        this.rTitem.embedAttachment(path);
        this.doc.save();
        DEmbeddedObject received = this.rTitem.getEmbeddedAttachment(this.attachFile.getName());
        EmbeddedObjectProxyTest.assertNotNull((String)"Embedded object to detach not found", (Object)received);
        String extractPath = "c:\\temp\\" + System.currentTimeMillis() + "extractFile.txt";
        received.extractFile(extractPath);
        File extracted = new File(extractPath);
        EmbeddedObjectProxyTest.assertTrue((String)"Extracted File should exist.", (boolean)extracted.exists());
        extracted.delete();
        this.attachFile.delete();
    }

    public void testGetName() {
        System.out.println("-> EmbeddedObjectProxy.testGetName");
        String path = this.attachFile.getAbsolutePath();
        DEmbeddedObject embedded = this.rTitem.embedAttachment(path);
        this.doc.save();
        DEmbeddedObject received = this.rTitem.getEmbeddedAttachment(this.attachFile.getName());
        EmbeddedObjectProxyTest.assertNotNull((String)"Embedded object not found", (Object)received);
        EmbeddedObjectProxyTest.assertEquals((String)"The content (name) of the embedded object should be equal to the given name.", (String)this.attachFile.getName(), (String)embedded.getName());
        EmbeddedObjectProxyTest.assertEquals((String)"The content (name) of both embedded objects should be equal.", (String)embedded.getName(), (String)received.getName());
        this.attachFile.delete();
    }

    public void testRemove() {
        System.out.println("-> EmbeddedObjectProxy.testRemove");
        String path = this.attachFile.getAbsolutePath();
        this.rTitem.embedAttachment(path);
        this.doc.save();
        DEmbeddedObject rec1 = this.rTitem.getEmbeddedAttachment(this.attachFile.getName());
        EmbeddedObjectProxyTest.assertNotNull((String)"Embedded object not found", (Object)rec1);
        EmbeddedObjectProxyTest.assertEquals((String)"This operation should result in the embedded's name.", (String)this.attachFile.getName(), (String)rec1.getName());
        rec1.remove();
        this.attachFile.delete();
    }

    public void setUpTest() {
        this.itemName = "some_item_that_does_surely_not_exist";
        String suf = System.currentTimeMillis() + "testEmbedAndGetter";
        String pre = ".txt";
        this.attachFile = null;
        try {
            this.attachFile = File.createTempFile(suf, pre);
        }
        catch (IOException e) {
            EmbeddedObjectProxyTest.assertTrue((String)"Could not create test attachment file.", (boolean)false);
        }
        this.doc = this.getDatabase().createDocument();
        this.rTitem = this.doc.createRichTextItem(this.itemName);
    }
}

