/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseItemProxyTest;
import de.jakop.lotus.domingo.DBaseItem;
import de.jakop.lotus.domingo.DDateRange;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DItem;
import de.jakop.lotus.domingo.util.GregorianDate;
import de.jakop.lotus.domingo.util.GregorianDateTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class ItemProxyTest
extends BaseItemProxyTest {
    private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public ItemProxyTest(String name) {
        super(name);
    }

    protected DBaseItem createDBaseItem() {
        DDocument doc = this.getDatabase().createDocument();
        DItem item = doc.appendItemValue(this.getItemName());
        return item;
    }

    protected DBaseItem createDBaseItem(double d) {
        DDocument doc = this.getDatabase().createDocument();
        DItem item = doc.appendItemValue(this.getItemName(), d);
        return item;
    }

    protected DBaseItem createDBaseItem(int i) {
        DDocument doc = this.getDatabase().createDocument();
        DItem item = doc.appendItemValue(this.getItemName(), i);
        return item;
    }

    protected DBaseItem createDBaseItem(String s) {
        DDocument doc = this.getDatabase().createDocument();
        DItem item = doc.appendItemValue(this.getItemName(), s);
        return item;
    }

    protected DBaseItem createDBaseItem(Calendar d) {
        DDocument doc = this.getDatabase().createDocument();
        DItem item = doc.appendItemValue(this.getItemName(), d);
        return item;
    }

    protected DBaseItem createDBaseItem(List l) {
        DDocument doc = this.getDatabase().createDocument();
        DItem item = doc.appendItemValue(this.getItemName(), l);
        return item;
    }

    public void testAppendToTextList() {
        System.out.println("-> testAppendToTextList");
        ArrayList l = new ArrayList();
        DItem item = (DItem)this.createDBaseItem(l);
        List before = item.getValues();
        ItemProxyTest.assertNotNull((String)"Value list is null", (Object)before);
        ItemProxyTest.assertEquals((String)"invalid size of value list", (int)1, (int)before.size());
        ItemProxyTest.assertEquals((String)"first value must be the empty string", (Object)"", before.get(0));
        String secondValue = "second entry";
        item.appendToTextList(secondValue);
        List after = item.getValues();
        ItemProxyTest.assertEquals((String)"invalid size of value list", (int)2, (int)after.size());
        ItemProxyTest.assertEquals((String)"Invalid first value", (Object)"", after.get(0));
        ItemProxyTest.assertEquals((String)"second second value", (Object)secondValue, after.get(1));
    }

    public void testSetGetValueDateTime() {
        System.out.println("-> testSetGetValueDateTime");
        GregorianDate correct = new GregorianDate();
        DItem item = (DItem)this.createDBaseItem((Calendar)correct);
        Calendar date = null;
        try {
            date = item.getValueDateTime();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            ItemProxyTest.fail((String)e.getMessage());
        }
        System.out.println("date1 = " + this.format.format(correct.getTime()));
        System.out.println("date2 = " + this.format.format(date.getTime()));
        ItemProxyTest.assertNotNull((String)"Date value was a valid date, thus should be not null.", (Object)date);
        ItemProxyTest.assertEquals((String)"Both dates should be equal.", (Object)correct, (Object)date);
    }

    public void testSetGetValueDateRange() {
        System.out.println("-> testSetGetValueDateRange");
        GregorianDate calendar1 = new GregorianDate(2007, 2, 3);
        GregorianDate calendar2 = new GregorianDate();
        calendar2.add(1, 1);
        calendar2.add(2, 1);
        calendar2.add(5, 1);
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("range", (Calendar)calendar1, (Calendar)calendar2);
        DItem item = (DItem)doc.getFirstItem("range");
        DDateRange range = item.getValueDateRange();
        Calendar c1 = range.getFrom();
        Calendar c2 = range.getTo();
        System.out.println(calendar1);
        System.out.println(c1);
        ItemProxyTest.assertEquals((Object)calendar1, (Object)c1);
        ItemProxyTest.assertEquals((Object)calendar2, (Object)c2);
    }

    public void testSetGetValueInteger() {
        System.out.println("-> testSetGetValueInteger");
        int expected = 12;
        DItem item = (DItem)this.createDBaseItem(expected);
        int value = item.getValueInteger();
        ItemProxyTest.assertEquals((String)("Returned value should be " + expected + " and not " + value + "."), (int)expected, (int)value);
    }

    public void testSetGetValueDouble() {
        System.out.println("-> testSetGetValueDouble");
        double expected = 12.3;
        DItem item = (DItem)this.createDBaseItem(expected);
        double value = item.getValueDouble();
        ItemProxyTest.assertEquals((String)"Unexpected returned value", (double)expected, (double)value, (double)0.001);
    }

    public void testSetGetValueString() {
        System.out.println("-> testSetGetValueString");
        String expected = "someValueXXX";
        DItem item = (DItem)this.createDBaseItem(expected);
        String value = item.getValueString();
        ItemProxyTest.assertEquals((String)"Unexpected returned value", (String)expected, (String)value);
    }

    public void testSetGetValues() {
        System.out.println("-> testSetGetValues");
        String exp1 = "someValue1";
        String exp2 = "someValue2";
        ArrayList<String> expList = new ArrayList<String>();
        expList.add(exp1);
        expList.add(exp2);
        DItem item = (DItem)this.createDBaseItem(expList);
        List values = item.getValues();
        ItemProxyTest.assertEquals((String)("Item should contain the list " + expList + " but contains: " + values), expList, (Object)values);
        ArrayList<GregorianDateTime> dateList = new ArrayList<GregorianDateTime>();
        GregorianDateTime calendar = new GregorianDateTime();
        calendar.clear(14);
        dateList.add(calendar);
        dateList.add(calendar);
        DItem item2 = (DItem)this.createDBaseItem(dateList);
        List values2 = item2.getValues();
        System.out.println("dateRef = " + this.format.format(calendar.getTime()) + "(" + calendar.getTime().getTime() + ")");
        System.out.println("date[0] = " + this.format.format(((Calendar)values2.get(0)).getTime()));
        System.out.println("date[1] = " + this.format.format(((Calendar)values2.get(0)).getTime()));
        ItemProxyTest.assertEquals((String)"date 0 should be equal", (Object)calendar, (Object)((Calendar)values2.get(0)));
        ItemProxyTest.assertEquals((String)"date 1 should be equal", (Object)calendar, (Object)((Calendar)values2.get(1)));
    }

    public void testIsSummary() {
        DBaseItem item = this.createDBaseItem();
        if (item instanceof DItem) {
            ItemProxyTest.assertTrue((String)"The summary flag of this item should be true.", (boolean)((DItem)item).isSummary());
        } else {
            ItemProxyTest.assertTrue((String)"The summary flag of this item should be false.", (!((DItem)item).isSummary() ? 1 : 0) != 0);
        }
    }

    public void testSetSummary() {
        DBaseItem item = this.createDBaseItem();
        if (item instanceof DItem) {
            ItemProxyTest.assertTrue((String)"The summary flag of this item should indicate true.", (boolean)((DItem)item).isSummary());
        } else {
            ItemProxyTest.assertTrue((String)"The summary flag of this item should indicate false.", (!((DItem)item).isSummary() ? 1 : 0) != 0);
        }
        ((DItem)item).setSummary(false);
        ItemProxyTest.assertTrue((String)"The summary flag of this item should be false.", (!((DItem)item).isSummary() ? 1 : 0) != 0);
        ((DItem)item).setSummary(true);
        ItemProxyTest.assertTrue((String)"The summary flag of this item should again be true.", (boolean)((DItem)item).isSummary());
    }

    public void testSetReaders() {
        DBaseItem item = this.createDBaseItem();
        if (item instanceof DItem) {
            ItemProxyTest.assertTrue((String)"The summary flag of this item should indicate true.", (!((DItem)item).isReaders() ? 1 : 0) != 0);
            ((DItem)item).setReaders(true);
            ItemProxyTest.assertTrue((String)"The summary flag of this item should be false.", (boolean)((DItem)item).isReaders());
            ((DItem)item).setReaders(false);
            ItemProxyTest.assertTrue((String)"The summary flag of this item should again be true.", (!((DItem)item).isReaders() ? 1 : 0) != 0);
        }
    }

    public void testSetAuthors() {
        DBaseItem item = this.createDBaseItem();
        if (item instanceof DItem) {
            ItemProxyTest.assertTrue((String)"The summary flag of this item should indicate true.", (!((DItem)item).isAuthors() ? 1 : 0) != 0);
            ((DItem)item).setAuthors(true);
            ItemProxyTest.assertTrue((String)"The summary flag of this item should be false.", (boolean)((DItem)item).isAuthors());
            ((DItem)item).setAuthors(false);
            ItemProxyTest.assertTrue((String)"The summary flag of this item should again be true.", (!((DItem)item).isAuthors() ? 1 : 0) != 0);
        }
    }

    public void testSetTimezone() {
        DItem item = (DItem)this.createDBaseItem();
        SimpleTimeZone timezone = new SimpleTimeZone(1, "CET");
        item.setValueDateTime((TimeZone)timezone);
        if (item instanceof DItem) {
            ItemProxyTest.assertTrue((String)"The summary flag of this item should indicate true.", (!item.isAuthors() ? 1 : 0) != 0);
            item.setAuthors(true);
            ItemProxyTest.assertTrue((String)"The summary flag of this item should be false.", (boolean)item.isAuthors());
            item.setAuthors(false);
            ItemProxyTest.assertTrue((String)"The summary flag of this item should again be true.", (!item.isAuthors() ? 1 : 0) != 0);
        }
    }
}

