/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseDocumentProxyTest;
import de.jakop.lotus.domingo.DBaseDocument;
import de.jakop.lotus.domingo.DProfileDocument;
import java.util.Random;

public final class ProfileDocumentProxyTest
extends BaseDocumentProxyTest {
    private final Random random = new Random();
    private String profileName;
    private String profileKey;

    public ProfileDocumentProxyTest(String name) {
        super(name);
    }

    public void testGetNameOfProfile() {
        System.out.println("-> testGetNameOfProfile");
        String profileNameG = "GN" + System.currentTimeMillis();
        String profileKeyG = "GN" + System.currentTimeMillis();
        DProfileDocument doc = this.getDatabase().getProfileDocument(profileNameG, profileKeyG);
        String key = doc.getNameOfProfile();
        ProfileDocumentProxyTest.assertEquals((String)"The keys should be equal.", (String)profileKeyG, (String)key);
    }

    public void testGetKey() {
        System.out.println("-> testGetKey");
        String profileNameG = "G" + System.currentTimeMillis();
        String profileKeyG = "G" + System.currentTimeMillis();
        DProfileDocument doc = this.getDatabase().getProfileDocument(profileNameG, profileKeyG);
        String key = doc.getKey();
        ProfileDocumentProxyTest.assertEquals((String)"The keys should be equal.", (String)profileKeyG, (String)key);
    }

    public void testSave() {
        System.out.println("-> testSave");
        String profileNameS = "B" + System.currentTimeMillis();
        String profileKeyS = "Key" + System.currentTimeMillis();
        DProfileDocument doc = this.getDatabase().getProfileDocument(profileNameS, profileKeyS);
        String someValue = "someValueForTestSave";
        doc.appendItemValue(this.getItemName(), someValue);
        doc.save();
        DProfileDocument received = this.getDatabase().getProfileDocument(profileNameS, profileKeyS);
        String receivedValue = received.getItemValueString(this.getItemName());
        ProfileDocumentProxyTest.assertEquals((String)"The Document received from the database should contain an item, but does not.", (String)someValue, (String)receivedValue);
        doc.remove(true);
    }

    public void testSaveWithOneArgument() {
        System.out.println("-> testSaveWithOneArgument");
        String profileNameE = "S_bool_" + System.currentTimeMillis();
        String profileKeyE = "K_S_bool" + System.currentTimeMillis();
        DProfileDocument doc = this.getDatabase().getProfileDocument(profileNameE, profileKeyE);
        String someValue = "someValueForTestSave";
        doc.appendItemValue(this.getItemName(), someValue);
        boolean saved = doc.save(true);
        ProfileDocumentProxyTest.assertTrue((String)"The save action should work properly.", (boolean)saved);
        doc.appendItemValue(this.getItemName() + this.getItemName(), someValue);
        saved = doc.save(false);
        ProfileDocumentProxyTest.assertTrue((String)"The unforced save action should work properly.", (boolean)saved);
        DProfileDocument received = this.getDatabase().getProfileDocument(profileNameE, profileKeyE);
        ProfileDocumentProxyTest.assertNotNull((String)"The received document should exist.", (Object)received);
        String receivedValue = received.getItemValueString(this.getItemName());
        ProfileDocumentProxyTest.assertEquals((String)"Document should contain an item, but does not.", (String)someValue, (String)receivedValue);
        String receivedValue1 = received.getItemValueString(this.getItemName() + this.getItemName());
        ProfileDocumentProxyTest.assertEquals((String)"Document should contain a second item, but does not.", (String)someValue, (String)receivedValue1);
        doc.remove(true);
    }

    public void testSaveWithTwoArguments() {
        System.out.println("-> testSaveWithTwoArguments");
        String profileNameE = "S_boolbool_" + System.currentTimeMillis();
        String profileKeyE = "K_S_boolbool" + System.currentTimeMillis();
        DProfileDocument doc = this.getDatabase().getProfileDocument(profileNameE, profileKeyE);
        String someValue = "someValueForTestSave";
        doc.appendItemValue(this.getItemName(), someValue);
        boolean saved = doc.save(true, false);
        ProfileDocumentProxyTest.assertTrue((String)"The save action should work properly.", (boolean)saved);
        doc.appendItemValue(this.getItemName() + this.getItemName(), someValue);
        saved = doc.save(true, true);
        ProfileDocumentProxyTest.assertTrue((String)"The unforced save action should work properly.", (boolean)saved);
        DProfileDocument received = this.getDatabase().getProfileDocument(profileNameE, profileKeyE);
        ProfileDocumentProxyTest.assertNotNull((String)"The received document should exist.", (Object)received);
        String receivedValue = received.getItemValueString(this.getItemName());
        ProfileDocumentProxyTest.assertEquals((String)"Document should contain an item, but does not.", (String)someValue, (String)receivedValue);
        String receivedValue1 = received.getItemValueString(this.getItemName() + this.getItemName());
        ProfileDocumentProxyTest.assertEquals((String)"Document should contain a second item, but does not.", (String)someValue, (String)receivedValue1);
        doc.remove(true);
    }

    public void testEquals() {
        System.out.println("-> testEquals");
        String profileNameE = "A" + System.currentTimeMillis();
        String profileKeyE = "K" + System.currentTimeMillis();
        DProfileDocument doc = this.getDatabase().getProfileDocument(profileNameE, profileKeyE);
        doc.replaceItemValue("Test", "abcdefgh");
        doc.save();
        DProfileDocument receivedDoc = this.getDatabase().getProfileDocument(profileNameE, profileKeyE);
        ProfileDocumentProxyTest.assertEquals((String)"Documents should be equal but are not.", (String)"abcdefgh", (String)receivedDoc.getItemValueString("Test"));
        DBaseDocument anotherOne = this.createDBaseDocument();
        ProfileDocumentProxyTest.assertTrue((String)"Documents should NOT be equal but are.", (!doc.equals(anotherOne) ? 1 : 0) != 0);
        doc.remove(true);
    }

    protected DBaseDocument createDBaseDocument() {
        this.profileName = this.createStringKey();
        this.profileKey = this.createStringKey();
        return this.getDatabase().getProfileDocument(this.profileName, this.profileKey);
    }

    private String createStringKey() {
        return "" + System.currentTimeMillis() + this.random.nextInt(10000);
    }

    public void setUpConcreteTest() {
        this.profileName = "someProfileName";
        this.profileKey = "someProfileKey";
    }
}

