/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseItemProxyTest;
import de.jakop.lotus.domingo.DBaseItem;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DEmbeddedObject;
import de.jakop.lotus.domingo.DRichTextItem;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;

public final class RichTextItemProxyTest
extends BaseItemProxyTest {
    public RichTextItemProxyTest(String name) {
        super(name);
    }

    public void testEmbedAndGetAttachment() {
        System.out.println("-> testEmbedAndGetAttachment");
        String suf = System.currentTimeMillis() + "testEmbedAndGetAttachment";
        String pre = ".txt";
        File file = null;
        try {
            file = File.createTempFile(suf, pre);
        }
        catch (IOException e) {
            RichTextItemProxyTest.assertTrue((String)"Could not create test attachment file.", (boolean)false);
        }
        DDocument doc = this.getDatabase().createDocument();
        DRichTextItem rTitem = doc.createRichTextItem(this.getItemName());
        DEmbeddedObject embedded = rTitem.embedAttachment(file.getAbsolutePath());
        doc.save();
        DEmbeddedObject received = rTitem.getEmbeddedAttachment(file.getName());
        RichTextItemProxyTest.assertNotNull((String)"No attachment found", (Object)received);
        RichTextItemProxyTest.assertEquals((String)"The content (name) of the embedded object should be equal to the given name.", (String)file.getName(), (String)embedded.getName());
        RichTextItemProxyTest.assertEquals((String)"The content (name) of both embedded objects should be equal.", (String)embedded.getName(), (String)received.getName());
        file.delete();
        doc.remove(true);
    }

    public void testGetEmbeddedObjects() {
        System.out.println("-> testGetEmbeddedObjects");
        DDocument doc = this.getDatabase().createDocument();
        DRichTextItem rtItem1 = doc.createRichTextItem(this.getItemName());
        String pre1 = System.currentTimeMillis() + "testGetEmbeddedObjects1";
        String pre2 = System.currentTimeMillis() + "testGetEmbeddedObjects2";
        String suf = ".txt";
        File file1 = null;
        File file2 = null;
        try {
            file1 = File.createTempFile(pre1, suf);
            file2 = File.createTempFile(pre2, suf);
        }
        catch (IOException e) {
            RichTextItemProxyTest.assertTrue((String)"Could not create test attachment file.", (boolean)false);
        }
        String key1 = file1.getAbsolutePath();
        String key2 = file2.getAbsolutePath();
        rtItem1.embedAttachment(key1);
        rtItem1.embedAttachment(key2);
        doc.save();
        Iterator it = rtItem1.getEmbeddedObjects();
        int eOCounter = 0;
        while (it.hasNext()) {
            DEmbeddedObject eo = (DEmbeddedObject)it.next();
            ++eOCounter;
            RichTextItemProxyTest.assertNotNull((String)"The embedded object should not be null.", (Object)eo);
            boolean ok1 = file1.getName().equals(eo.getName());
            boolean ok2 = file2.getName().equals(eo.getName());
            RichTextItemProxyTest.assertTrue((String)"The name of the embedded object should be the same as the name at embedding.", (ok1 || ok2 ? 1 : 0) != 0);
        }
        RichTextItemProxyTest.assertEquals((String)"There should be two embedded objects.", (int)2, (int)eOCounter);
        file1.delete();
        file2.delete();
        doc.remove(true);
    }

    public void testGetUnformattedText() {
        System.out.println("-> testGetUnformattedText");
        DDocument doc = this.getDatabase().createDocument();
        DRichTextItem rtItem = doc.createRichTextItem(this.getItemName());
        String val = "This text is stored in a RichTextItem to test the method RichTextItem.getUnformattedText()";
        rtItem.appendText(val);
        doc.save();
        DRichTextItem rtItem2 = (DRichTextItem)doc.getFirstItem(this.getItemName());
        String comp = rtItem2.getUnformattedText();
        RichTextItemProxyTest.assertEquals((String)val, (String)comp);
        doc.removeItem(this.getItemName());
        rtItem = doc.createRichTextItem(this.getItemName());
        rtItem.appendText(this.getBigText());
        rtItem2 = (DRichTextItem)doc.getFirstItem(this.getItemName());
        comp = rtItem2.getUnformattedText();
        String compare = RichTextItemProxyTest.replaceAll(RichTextItemProxyTest.replaceAll(comp, "\n", ""), "\r", "");
        RichTextItemProxyTest.assertEquals((String)this.getBigText(), (String)compare);
        doc.remove(true);
    }

    private static String replaceAll(String text, String repl, String with) {
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public void testFormats() {
        System.out.println("-> testFormats");
        DDocument doc = this.getDatabase().createDocument();
        DRichTextItem rtItem1 = doc.createRichTextItem(this.getItemName());
        rtItem1.appendText("some text");
        rtItem1.addNewLine();
        rtItem1.appendText("some text");
        rtItem1.addNewLine(2);
        rtItem1.appendText("some text");
        rtItem1.addNewLine(2, true);
        rtItem1.appendText("some text");
        rtItem1.addNewLine(2, false);
        rtItem1.appendText("some text");
        rtItem1.addTab();
        rtItem1.appendText("some text");
        rtItem1.addTab(2);
        rtItem1.appendText("some text");
        doc.save();
        doc.remove(true);
    }

    protected DBaseItem createDBaseItem() {
        DDocument doc = this.getDatabase().createDocument();
        DRichTextItem item = doc.createRichTextItem(this.getItemName());
        return item;
    }

    private String getBigText() {
        ResourceBundle bundle = ResourceBundle.getBundle("de.jakop.lotus.domingo.test-values");
        return bundle.getString("value.string.long");
    }
}

