/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseProxyTest;
import de.jakop.lotus.domingo.DBaseDocument;
import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DLog;
import de.jakop.lotus.domingo.DNotesException;
import java.util.List;

public final class SessionProxyTest
extends BaseProxyTest {
    public SessionProxyTest(String name) {
        super(name);
    }

    public void setUpTest() {
    }

    public void testCreateDatabase() {
        System.out.println("-> testCreateDatabase");
        String dbName = "testCreateDatabase_" + System.currentTimeMillis() + ".nsf";
        DDatabase database = this.getSession().createDatabase(this.getServerName(), dbName);
        SessionProxyTest.assertNotNull((String)"Database file should exist.", (Object)database);
        DDocument doc = database.createDocument();
        SessionProxyTest.assertTrue((String)"Document should have been saved.", (boolean)doc.save());
        database.remove();
    }

    public void testGetDatabase() {
        String databaseName = "log.nsf";
        DDatabase database = null;
        try {
            database = this.getSession().getDatabase(this.getServerName(), databaseName);
        }
        catch (DNotesException e) {
            this.fail("Cannot open database " + this.getServerName() + "!!" + databaseName, e);
        }
        SessionProxyTest.assertNotNull((String)"database not found", (Object)database);
        SessionProxyTest.assertTrue((String)"Wrong path/filename", (boolean)database.getFilePath().endsWith(databaseName));
    }

    public void testGetUserName() {
        System.out.println("-> testGetUserName");
        String userName = this.getSession().getUserName();
        SessionProxyTest.assertTrue((String)"At least a string longer than 0 should be returned.", (userName != null && userName.length() > 0 ? 1 : 0) != 0);
    }

    public void testGetCommonUserName() {
        System.out.println("-> testGetCommonUserName");
        String userName = this.getSession().getCommonUserName();
        SessionProxyTest.assertTrue((String)"At least a string longer than 0 should be returned.", (userName != null && userName.length() > 0 ? 1 : 0) != 0);
    }

    public void testGetCanonicalUserName() {
        System.out.println("-> testGetCanonicalUserName");
        String userName = this.getSession().getCanonicalUserName();
        SessionProxyTest.assertTrue((String)"At least a string longer than 0 should be returned.", (userName != null && userName.length() > 0 ? 1 : 0) != 0);
    }

    public void testIsOnServer() {
        System.out.println("-> testIsOnServer");
        boolean isOnServer = this.getSession().isOnServer();
        if (this.isDIIOP()) {
            SessionProxyTest.assertTrue((String)"Method isOnServer Should return true.", (boolean)isOnServer);
        } else {
            SessionProxyTest.assertTrue((String)"Method isOnServer Should return false.", (!isOnServer ? 1 : 0) != 0);
        }
    }

    public void testGetEnvironmentString() {
        System.out.println("-> testGetEnvironmentString");
        String env = "Directory";
        this.getSession().setEnvironmentString(env, "XXX", false);
        String value = this.getSession().getEnvironmentString(env);
        SessionProxyTest.assertTrue((String)("Environment not found: " + env), (value != null && value.length() > 0 ? 1 : 0) != 0);
    }

    public void testGetEnvironmentValue() {
        System.out.println("-> testGetEnvironmentString");
        String env = "Directory";
        this.getSession().setEnvironmentString(env, "XXX", false);
        Object value = this.getSession().getEnvironmentValue(env);
        SessionProxyTest.assertTrue((boolean)(value instanceof String));
        SessionProxyTest.assertTrue((String)("Environment not found: " + env), (value != null && ((String)value).length() > 0 ? 1 : 0) != 0);
    }

    public void testGetEnvironmentStringFalse() {
        System.out.println("-> testGetEnvironmentString");
        String env = "Directory";
        String value = this.getSession().getEnvironmentString(env, false);
        SessionProxyTest.assertTrue((String)("Environment not found: " + env), (value != null && value.length() > 0 ? 1 : 0) != 0);
    }

    public void testGetEnvironmentValueFalse() {
        System.out.println("-> testGetEnvironmentString");
        String env = "Directory";
        Object value = this.getSession().getEnvironmentValue(env, false);
        SessionProxyTest.assertTrue((boolean)(value instanceof String));
        SessionProxyTest.assertTrue((String)("Environment not found: " + env), (value != null && ((String)value).length() > 0 ? 1 : 0) != 0);
    }

    public void testEvaluate() {
        System.out.println("-> testEvaluate");
        List obj = null;
        try {
            obj = this.getSession().evaluate("\"A\": \"B\": \"C\"");
        }
        catch (DNotesException e) {
            SessionProxyTest.fail((String)e.getMessage());
            e.printStackTrace();
        }
        SessionProxyTest.assertTrue((boolean)(obj instanceof List));
        List list = obj;
        SessionProxyTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        SessionProxyTest.assertTrue((boolean)"A".equals(list.get(0)));
        SessionProxyTest.assertTrue((boolean)"B".equals(list.get(1)));
        SessionProxyTest.assertTrue((boolean)"C".equals(list.get(2)));
        DDatabase db = null;
        DDocument doc = null;
        doc = (DDocument)this.getDatabase().getAllDocuments().next();
        try {
            obj = this.getSession().evaluate("@UserNamesList", (DBaseDocument)doc);
            System.out.println("result: " + obj);
        }
        catch (DNotesException e) {
            SessionProxyTest.fail((String)e.getMessage());
            e.printStackTrace();
        }
        String databaseName = "log.nsf";
        try {
            db = this.getSession().getDatabase("", databaseName);
        }
        catch (DNotesException e1) {
            e1.printStackTrace();
            SessionProxyTest.fail((String)("Cannot open local database " + databaseName));
        }
        doc = (DDocument)db.getAllDocuments().next();
        try {
            obj = this.getSession().evaluate("@UserNamesList", (DBaseDocument)doc);
            System.out.println("result: " + obj);
        }
        catch (DNotesException e) {
            SessionProxyTest.fail((String)e.getMessage());
            e.printStackTrace();
        }
        SessionProxyTest.assertTrue((boolean)(obj instanceof List));
        SessionProxyTest.assertTrue((boolean)(obj instanceof List));
    }

    public void testCreateLog() {
        System.out.println("-> testCreateLog");
        DLog log = this.getSession().createLog("Domingo_Log");
        log.openNotesLog(this.getServerName(), "log.nsf");
        log.logAction("log something");
    }
}

