/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DNotesException;
import de.jakop.lotus.domingo.DNotesFactory;
import de.jakop.lotus.domingo.DNotesRuntimeException;
import de.jakop.lotus.domingo.DSession;
import java.util.Calendar;
import java.util.Iterator;

public final class TestStability {
    public static void main(String[] args) {
        TestStability.log("Start");
        TestStability.logMem();
        TestStability test = new TestStability();
        test.run();
        TestStability.logMem();
        TestStability.log("Finished");
    }

    private void run() {
        int i;
        TestStability.log("run repeated tests");
        for (i = 0; i < 10; ++i) {
            TestStability.logMem();
            this.test();
            this.sleep(10);
        }
        TestStability.log("Wait, run gc, run finalizers");
        for (i = 0; i < 10; ++i) {
            System.gc();
            this.sleep(50);
            TestStability.logMem();
        }
        TestStability.logMem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        try {
            DNotesFactory factory = DNotesFactory.getInstance();
            DSession session = factory.getSession();
            DDatabase database = session.getDatabase("", "log.nsf");
            Iterator iterator = database.getAllDocuments();
            while (iterator.hasNext()) {
                DDocument doc = (DDocument)iterator.next();
                doc.replaceItemValue("Form", "Test");
                doc.getLastModified();
                doc.replaceItemValue("Calendar", Calendar.getInstance());
            }
        }
        catch (DNotesException e) {
            e.printStackTrace();
        }
        finally {
            try {
                DNotesFactory.dispose();
            }
            catch (DNotesRuntimeException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static void logMem() {
        System.out.println("Free Memory: " + Runtime.getRuntime().freeMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(int millis) {
        try {
            TestStability testStability = this;
            synchronized (testStability) {
                this.wait(millis);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }
}

