/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseProxyTest;
import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DNotesException;
import de.jakop.lotus.domingo.DView;
import de.jakop.lotus.domingo.DViewEntry;
import de.jakop.lotus.domingo.util.GregorianDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public final class ViewEntryProxyTest
extends BaseProxyTest {
    private DDatabase newDB = null;
    private DView newView = null;
    private Calendar correctNow = null;

    public ViewEntryProxyTest(String name) {
        super(name);
    }

    protected void setUpTest() {
        this.createNewDBAndView("testViewEntryProxy_" + System.currentTimeMillis() + ".nsf");
    }

    protected void tearDown() throws Exception {
        if (this.newDB != null) {
            this.newDB.remove();
            this.newDB = null;
        }
    }

    public void testGetColumnValues() {
        System.out.println("-> testGetColumnValues");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("somePath");
        list.add(this.correctNow);
        list.add("ObjStoreName");
        list.add("DbName1");
        Iterator it = this.newView.getAllEntriesByKey(list, true);
        DViewEntry entry = (DViewEntry)it.next();
        List colVals = entry.getColumnValues();
        ViewEntryProxyTest.assertEquals((String)"First ColumnValue does not match.", (Object)"somePath", colVals.get(0));
        ViewEntryProxyTest.assertEquals((String)"Second ColumnValue does not match.", (Object)this.correctNow, colVals.get(1));
        ViewEntryProxyTest.assertEquals((String)"Third ColumnValue does not match.", (Object)"ObjStoreName", colVals.get(2));
        ViewEntryProxyTest.assertEquals((String)"Fourth ColumnValue does not match.", (Object)"DbName1", colVals.get(3));
        ViewEntryProxyTest.assertEquals((String)"Fifth ColumnValue does not match.", (Object)"DbTitle", colVals.get(4));
    }

    public void testGetDocument() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("somePath");
        list.add(this.correctNow);
        list.add("ObjStoreName");
        list.add("DbName1");
        Iterator it = this.newView.getAllEntriesByKey(list, true);
        DViewEntry entry = (DViewEntry)it.next();
        DDocument doc = entry.getDocument();
        ViewEntryProxyTest.assertNotNull((String)"There should be a document.", (Object)doc);
        ViewEntryProxyTest.assertNotNull((String)"The document also should have a UniId.", (Object)doc.getUniversalID());
    }

    public void testIsDocument() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("somePath");
        list.add(this.correctNow);
        list.add("ObjStoreName");
        list.add("DbName1");
        Iterator it = this.newView.getAllEntriesByKey(list, true);
        DViewEntry entry = (DViewEntry)it.next();
        ViewEntryProxyTest.assertTrue((String)"The ViewEntry should represent a document.", (boolean)entry.isDocument());
    }

    public void testIsCategory() {
    }

    public void testIsTotal() {
    }

    private void createNewDBAndView(String name) {
        String dbName = name.replaceAll(".nsf", "_" + System.currentTimeMillis() + ".nsf");
        this.correctNow = new GregorianDate();
        DDatabase db = null;
        try {
            db = this.getSession().getDatabase(this.getServerName(), "log.ntf");
        }
        catch (DNotesException e1) {
            e1.printStackTrace();
            ViewEntryProxyTest.fail((String)"Cannot open database log.ntf");
        }
        try {
            this.newDB = db.createDatabaseFromTemplate(this.getServerName(), dbName, true);
        }
        catch (DNotesException e) {
            ViewEntryProxyTest.assertTrue((String)"Could not create DB from template.", (boolean)false);
        }
        ViewEntryProxyTest.assertNotNull((String)"bd is null", (Object)this.newDB);
        DDocument doc1 = this.newDB.createDocument();
        doc1.replaceItemValue("Form", "ObjStoreUsageForm");
        doc1.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc1.replaceItemValue("DbName", "DbName1");
        doc1.replaceItemValue("DbTitle", "DbTitle");
        doc1.replaceItemValue("DocCount", 2);
        doc1.replaceItemValue("Server", "somePath");
        doc1.replaceItemValue("StartTime", this.correctNow);
        doc1.save();
        DDocument doc2 = this.newDB.createDocument();
        doc2.replaceItemValue("Form", "ObjStoreUsageForm");
        doc2.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc2.replaceItemValue("DbName", "DbName1");
        doc2.replaceItemValue("DbTitle", "DbTitle");
        doc2.replaceItemValue("DocCount", 2);
        doc2.replaceItemValue("Server", "somePath");
        doc2.replaceItemValue("StartTime", this.correctNow);
        doc2.save();
        DDocument doc3 = this.newDB.createDocument();
        doc3.replaceItemValue("Form", "ObjStoreUsageForm");
        doc3.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc3.replaceItemValue("DbName", "DbName2");
        doc3.replaceItemValue("DbTitle", "DbTitle");
        doc3.replaceItemValue("DocCount", 2);
        doc3.replaceItemValue("Server", "somePath");
        doc3.replaceItemValue("StartTime", this.correctNow);
        doc3.save();
        DDocument doc4 = this.newDB.createDocument();
        doc4.replaceItemValue("Form", "ObjStoreUsageForm");
        doc4.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc4.replaceItemValue("DbName", "DbName2");
        doc4.replaceItemValue("DbTitle", "DbTitle");
        doc4.replaceItemValue("DocCount", 2);
        doc4.replaceItemValue("Server", "somePath");
        doc4.replaceItemValue("StartTime", this.correctNow);
        doc4.save();
        this.newView = this.newDB.getView("Objektspeicherbenutzung");
    }
}

