/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseProxyTest;
import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DNotesException;
import de.jakop.lotus.domingo.DView;
import de.jakop.lotus.domingo.DViewEntry;
import de.jakop.lotus.domingo.util.GregorianDate;
import de.jakop.lotus.domingo.util.GregorianDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public final class ViewProxyTest
extends BaseProxyTest {
    private DDatabase newDB = null;
    private DView view = null;
    private DView newView = null;
    private Calendar correctNow = null;
    private String viewName = null;

    public ViewProxyTest(String name) {
        super(name);
    }

    public void testRefresh() {
    }

    public void testGetName() {
        System.out.println("-> ViewProxy.testGetName");
        String result = this.view.getName();
        ViewProxyTest.assertTrue((String)("View name should be '" + this.viewName + "' not '" + result + "'"), (boolean)this.viewName.equals(result));
    }

    public void testGetAllDocumentsByKeyList() {
        DDocument doc;
        System.out.println("-> testGetAllDocumentsByKeyList");
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.add("somePath");
        keys.add(this.correctNow);
        keys.add("ObjStoreName");
        keys.add("DbName1");
        int docCounter = 0;
        Iterator it = this.newView.getAllDocumentsByKey(keys, true);
        while (it.hasNext()) {
            doc = (DDocument)it.next();
            doc.getNoteID();
            ++docCounter;
        }
        ViewProxyTest.assertEquals((String)"View should have 2 documents.", (int)2, (int)docCounter);
        keys = new ArrayList();
        keys.add("somePath");
        keys.add(this.correctNow);
        keys.add("ObjStoreName");
        keys.add("DbName");
        docCounter = 0;
        it = this.newView.getAllDocumentsByKey(keys, false);
        while (it.hasNext()) {
            doc = (DDocument)it.next();
            doc.getNoteID();
            ++docCounter;
        }
        ViewProxyTest.assertTrue((String)("Found " + docCounter + " documents, but 4 expected."), (4 == docCounter ? 1 : 0) != 0);
    }

    public void testGetAllDocumentsByKeyString() {
        System.out.println("-> testGetAllDocumentsByKeyString");
        String key = "somePath";
        int docCounter = 0;
        Iterator it = this.newView.getAllDocumentsByKey(key, true);
        while (it.hasNext()) {
            DDocument doc = (DDocument)it.next();
            doc.getNoteID();
            ++docCounter;
        }
        ViewProxyTest.assertEquals((String)"View should have 4 documents.", (int)4, (int)docCounter);
    }

    public void testGetDocumentByKeyList() {
        System.out.println("-> testGetDocumentByKeyList");
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.add("somePath");
        keys.add(this.correctNow);
        keys.add("ObjStoreName");
        keys.add("DbName1");
        DDocument doc = this.newView.getDocumentByKey(keys, true);
        ViewProxyTest.assertNotNull((String)"The view should have a document with this key list.", (Object)doc);
        ViewProxyTest.assertEquals((String)"The Document should have a field 'DbName'.", (String)"DbName1", (String)doc.getItemValueString("DbName"));
        keys = new ArrayList();
        keys.add("somePath");
        keys.add(this.correctNow);
        keys.add("ObjStoreName");
        keys.add("DbName");
        DDocument doc1 = this.newView.getDocumentByKey(keys, false);
        ViewProxyTest.assertNotNull((String)"The view should have a document with this key list.", (Object)doc1);
        String fieldDbName = doc1.getItemValueString("DbName");
        ViewProxyTest.assertTrue((String)"The Document should have a field 'DbName'.", ("DbName1".equals(fieldDbName) || "DbName2".equals(fieldDbName) ? 1 : 0) != 0);
    }

    public void testGetDocumentByKeyString() {
        System.out.println("-> testGetDocumentByKeyString");
        String key = "somePath";
        DDocument doc = this.newView.getDocumentByKey(key, true);
        ViewProxyTest.assertNotNull((String)"The view should contain a Document with that key.", (Object)doc);
        String fieldDBName = doc.getItemValueString("DbName");
        boolean match = "DbName1".equals(fieldDBName) || "DbName2".equals(fieldDBName);
        ViewProxyTest.assertTrue((String)"Document should have a field 'DbName'.", (boolean)match);
    }

    public void testGetAllEntries() {
        System.out.println("-> testGetAllEntries");
        Iterator it = this.newView.getAllEntries();
        int itCounter = 0;
        while (it.hasNext()) {
            DViewEntry entry = (DViewEntry)it.next();
            ViewProxyTest.assertNotNull((String)("ViewEntry " + itCounter + " should not be null."), (Object)entry);
            ++itCounter;
        }
        int expected = 4;
        ViewProxyTest.assertEquals((String)("The view should have " + expected + " entries."), (int)expected, (int)itCounter);
    }

    public void testGetAllEntriesFrom() {
        System.out.println("-> testGetAllEntriesFrom");
        Iterator it = this.newView.getAllEntries();
        int itCounter = 0;
        if (it.hasNext()) {
            DViewEntry entry = (DViewEntry)it.next();
            ViewProxyTest.assertNotNull((String)("ViewEntry " + itCounter + " should not be null."), (Object)entry);
            Iterator iter = this.newView.getAllEntries(entry);
            while (iter.hasNext()) {
                DViewEntry entry1 = (DViewEntry)iter.next();
                ViewProxyTest.assertNotNull((String)("ViewEntry " + itCounter + " should not be null."), (Object)entry1);
                if (!entry1.isDocument()) continue;
                ++itCounter;
            }
        }
        int expected = 4;
        ViewProxyTest.assertEquals((String)("The view should have " + expected + " entries."), (int)expected, (int)itCounter);
    }

    public void testGetAllEntriesByKeyString() {
        System.out.println("-> getAllEntriesByKeyString");
        String key = "somePath";
        Iterator it = this.newView.getAllEntriesByKey(key, true);
        int itCounter = 0;
        while (it.hasNext()) {
            DViewEntry entry = (DViewEntry)it.next();
            ViewProxyTest.assertNotNull((String)("ViewEntry " + itCounter + " should not be null."), (Object)entry);
            ++itCounter;
        }
        int expected = 4;
        ViewProxyTest.assertEquals((String)("The view should have " + expected + " entries."), (int)expected, (int)itCounter);
    }

    public void testGetAllCategories() {
        System.out.println("-> testGetAllCategories");
        DView categorisedView = this.getDatabase().getView("MiscEvents");
        Iterator iterator = categorisedView.getAllCategories(1);
        while (iterator.hasNext()) {
            DViewEntry entry = (DViewEntry)iterator.next();
            if (entry.isCategory()) {
                System.out.println("Category: " + entry.getColumnValues().toString());
                continue;
            }
            System.out.println("    not a category");
        }
    }

    public void testGetAllEntriesByKeyList() {
        System.out.println("-> getAllEntriesByKeyList");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("somePath");
        list.add(this.correctNow);
        list.add("ObjStoreName");
        list.add("DbName1");
        Iterator it = this.newView.getAllEntriesByKey(list, true);
        int itCounter = 0;
        while (it.hasNext()) {
            DViewEntry entry = (DViewEntry)it.next();
            ViewProxyTest.assertNotNull((String)("ViewEntry " + itCounter + " should not be null."), (Object)entry);
            ++itCounter;
        }
        int expected = 2;
        ViewProxyTest.assertEquals((String)("The view should have " + expected + " entries."), (int)expected, (int)itCounter);
        list = new ArrayList();
        list.add("somePath");
        list.add(this.correctNow);
        list.add("ObjStoreName");
        list.add("DbName");
        it = this.newView.getAllEntriesByKey(list, false);
        itCounter = 0;
        while (it.hasNext()) {
            DViewEntry entry = (DViewEntry)it.next();
            ViewProxyTest.assertNotNull((String)("ViewEntry " + itCounter + " should not be null."), (Object)entry);
            ++itCounter;
        }
        expected = 4;
        ViewProxyTest.assertEquals((String)("The view should have " + expected + " entries."), (int)expected, (int)itCounter);
    }

    private void createNewDBAndView(String name) {
        this.correctNow = new GregorianDate();
        DDatabase db = null;
        try {
            db = this.getSession().getDatabase("", "log.ntf");
        }
        catch (DNotesException e1) {
            e1.printStackTrace();
            ViewProxyTest.fail((String)"Cannot open local database log.ntf");
        }
        try {
            this.newDB = db.createDatabaseFromTemplate(this.getServerName(), name, true);
        }
        catch (DNotesException e) {
            ViewProxyTest.assertTrue((String)"Could not create DB from template.", (boolean)false);
        }
        DDocument doc1 = this.newDB.createDocument();
        doc1.replaceItemValue("Form", "ObjStoreUsageForm");
        doc1.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc1.replaceItemValue("DbName", "DbName1");
        doc1.replaceItemValue("DbTitle", "DbTitle");
        doc1.replaceItemValue("DocCount", 2);
        doc1.replaceItemValue("Server", "somePath");
        doc1.replaceItemValue("StartTime", this.correctNow);
        doc1.save();
        DDocument doc2 = this.newDB.createDocument();
        doc2.replaceItemValue("Form", "ObjStoreUsageForm");
        doc2.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc2.replaceItemValue("DbName", "DbName1");
        doc2.replaceItemValue("DbTitle", "DbTitle");
        doc2.replaceItemValue("DocCount", 2);
        doc2.replaceItemValue("Server", "somePath");
        doc2.replaceItemValue("StartTime", this.correctNow);
        doc2.save();
        DDocument doc3 = this.newDB.createDocument();
        doc3.replaceItemValue("Form", "ObjStoreUsageForm");
        doc3.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc3.replaceItemValue("DbName", "DbName2");
        doc3.replaceItemValue("DbTitle", "DbTitle");
        doc3.replaceItemValue("DocCount", 2);
        doc3.replaceItemValue("Server", "somePath");
        doc3.replaceItemValue("StartTime", this.correctNow);
        doc3.save();
        DDocument doc4 = this.newDB.createDocument();
        doc4.replaceItemValue("Form", "ObjStoreUsageForm");
        doc4.replaceItemValue("ObjStoreName", "ObjStoreName");
        doc4.replaceItemValue("DbName", "DbName2");
        doc4.replaceItemValue("DbTitle", "DbTitle");
        doc4.replaceItemValue("DocCount", 2);
        doc4.replaceItemValue("Server", "somePath");
        doc4.replaceItemValue("StartTime", this.correctNow);
        doc4.save();
        this.newView = this.newDB.getView("Objektspeicherbenutzung");
    }

    protected void setUpTest() {
        this.correctNow = new GregorianDateTime();
        this.viewName = "Verschiedene Ereignisse";
        this.view = this.getDatabase().getView(this.viewName);
        this.createNewDBAndView("testViewProxy_" + System.currentTimeMillis() + ".nsf");
    }

    protected void tearDown() throws Exception {
        this.newDB.remove();
    }
}

