/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.groupware;

import de.jakop.lotus.domingo.DNotesMonitor;
import de.jakop.lotus.domingo.groupware.CalendarEntryDigest;
import de.jakop.lotus.domingo.groupware.CalendarInterface;
import de.jakop.lotus.domingo.groupware.Email;
import de.jakop.lotus.domingo.groupware.EmailDigest;
import de.jakop.lotus.domingo.groupware.Groupware;
import de.jakop.lotus.domingo.groupware.GroupwareException;
import de.jakop.lotus.domingo.groupware.Mailbox;
import de.jakop.lotus.domingo.monitor.ConsoleMonitor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public final class GroupwareTest
extends TestCase {
    public void testCalendarInterfaceLocal() throws GroupwareException {
        ConsoleMonitor monitor = new ConsoleMonitor();
        monitor.setLevel(50);
        Groupware groupware = new Groupware("notes:///local", (DNotesMonitor)monitor);
        CalendarInterface calendar = groupware.getCalendar();
        GroupwareTest.assertNotNull((Object)calendar);
        GregorianCalendar fromDate = new GregorianCalendar();
        GregorianCalendar toDate = new GregorianCalendar();
        fromDate.set(2007, 9, 6, 0, 0, 0);
        toDate.set(2099, 10, 7, 23, 59, 59);
        List l = calendar.getObjects((Calendar)fromDate, (Calendar)toDate);
        monitor.info("Found " + l.size() + " entries");
        Iterator it = l.iterator();
        int counter = 1;
        while (it.hasNext()) {
            CalendarEntryDigest ced = (CalendarEntryDigest)it.next();
            String st = ced.getStartDateTime() == null ? "unknown" : ced.getStartDateTime().getTime().toString();
            monitor.info("Entry " + counter + " " + st + " " + ced.getSubject() + " " + ced.getUnid());
            ++counter;
        }
        groupware.close();
    }

    public void testSendMailLocal() throws GroupwareException {
        ConsoleMonitor monitor = new ConsoleMonitor();
        monitor.setLevel(50);
        Groupware groupware = new Groupware("notes:///local", (DNotesMonitor)monitor);
        this.sendMail(groupware);
        groupware.close();
    }

    public void xtestSendMailDIIOP() throws GroupwareException {
        ConsoleMonitor monitor = new ConsoleMonitor();
        monitor.setLevel(50);
        Groupware groupware = new Groupware("notes:///Kurt Riede:password@localhost", (DNotesMonitor)monitor);
        this.sendMail(groupware);
        groupware.close();
    }

    private void sendMail(Groupware groupware) throws GroupwareException {
        Mailbox mailbox = groupware.getMailbox();
        GroupwareTest.assertNotNull((Object)mailbox);
        String owner = mailbox.getOwner();
        System.out.println("Owner = " + owner);
        Email email = mailbox.newEmail();
        email.setFrom(owner);
        email.setSubject("Test");
        email.setRecipient(owner);
        email.setBody("Hello world!");
        mailbox.send(email);
    }

    public void testListMails() throws GroupwareException {
        ConsoleMonitor monitor = new ConsoleMonitor();
        monitor.setLevel(50);
        Groupware groupware = new Groupware("notes:///", (DNotesMonitor)monitor);
        Mailbox mailbox = groupware.getMailbox();
        Iterator inbox = mailbox.getInbox();
        if (!inbox.hasNext()) {
            System.out.println("no mails found!");
        }
        while (inbox.hasNext()) {
            EmailDigest emailDigest = (EmailDigest)inbox.next();
            Email email = mailbox.getEmail(emailDigest);
            System.out.println("--------------------------------");
            System.out.println("From: " + email.getFrom());
            System.out.println("To: " + email.getRecipients());
            System.out.println("Cc: " + email.getCc());
            System.out.println("Bcc: " + email.getBcc());
            System.out.println("Subject: " + email.getSubject());
            System.out.println("Message: ");
            System.out.println(email.getBody());
        }
    }
}

