/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.groupware.map;

import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.groupware.Email;
import de.jakop.lotus.domingo.groupware.map.EmailMapper;
import de.jakop.lotus.domingo.map.BaseMapperTest;
import de.jakop.lotus.domingo.map.Mapper;
import de.jakop.lotus.domingo.map.MethodNotFoundException;
import de.jakop.lotus.domingo.mock.MockDocument;

public final class EmailMapperTest
extends BaseMapperTest {
    public void testMapToDocument() throws MethodNotFoundException {
        Email email = new Email();
        MockDocument doc = new MockDocument();
        email.setPriority(Email.Priority.HIGH);
        email.setImportance(Email.Importance.HIGH);
        email.addCategories("Test1");
        email.addCategories("Test2");
        EmailMapper mapper = new EmailMapper();
        this.map((Mapper)mapper, email, (DDocument)doc);
        EmailMapperTest.assertEquals((String)"1", (String)doc.getItemValueString("Importance"));
        EmailMapperTest.assertEquals((String)"H", (String)doc.getItemValueString("DeliveryPriority"));
        EmailMapperTest.assertEquals((int)2, (int)doc.getItemValue("Categories").size());
        EmailMapperTest.assertTrue((boolean)doc.getItemValue("Categories").contains("Test1"));
        EmailMapperTest.assertTrue((boolean)doc.getItemValue("Categories").contains("Test2"));
    }

    public void testMapToInstance() throws MethodNotFoundException {
        Email email = new Email();
        MockDocument doc = new MockDocument();
        doc.replaceItemValue("DeliveryPriority", "H");
        doc.replaceItemValue("Importance", "1");
        EmailMapper mapper = new EmailMapper();
        this.map((Mapper)mapper, (DDocument)doc, email);
        EmailMapperTest.assertEquals((Object)Email.Priority.HIGH, (Object)email.getPriority());
        EmailMapperTest.assertEquals((Object)Email.Importance.HIGH, (Object)email.getImportance());
    }
}

