/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.map;

import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.map.BaseMapperTest;
import de.jakop.lotus.domingo.map.DirectMapper;
import de.jakop.lotus.domingo.map.Mapper;
import de.jakop.lotus.domingo.map.MethodNotFoundException;
import de.jakop.lotus.domingo.mock.MockDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DirectMapperTest
extends BaseMapperTest {
    private static final String TEST_ITEM_NAME = "Test";
    private static final String TEST_VALUE = "test-value";

    public void testMapString() {
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestString", String.class);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, TEST_VALUE);
        TestClass instance = new TestClass();
        this.map((Mapper)mapper, (DDocument)doc, instance);
        DirectMapperTest.assertEquals((String)TEST_VALUE, (String)instance.getTestString());
        instance.setTestString(TEST_VALUE);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((String)TEST_VALUE, (String)doc.getItemValueString(TEST_ITEM_NAME));
    }

    public void testMapList() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(TEST_VALUE);
        values.add(TEST_VALUE);
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestList", List.class);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, values);
        TestClass instance = new TestClass();
        this.map((Mapper)mapper, (DDocument)doc, instance);
        DirectMapperTest.assertEquals((int)2, (int)instance.getTestList().size());
        DirectMapperTest.assertEquals((Object)TEST_VALUE, instance.getTestList().get(0));
        DirectMapperTest.assertEquals((Object)TEST_VALUE, instance.getTestList().get(1));
        instance.setTestList(values);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((int)2, (int)doc.getItemValue(TEST_ITEM_NAME).size());
        DirectMapperTest.assertEquals((Object)TEST_VALUE, doc.getItemValue(TEST_ITEM_NAME).get(0));
        DirectMapperTest.assertEquals((Object)TEST_VALUE, doc.getItemValue(TEST_ITEM_NAME).get(1));
    }

    public void testMapIntegerType() {
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestIntType", Integer.TYPE);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, 2);
        TestClass instance = new TestClass();
        this.map((Mapper)mapper, (DDocument)doc, instance);
        DirectMapperTest.assertEquals((int)2, (int)instance.getTestIntType());
        instance.setTestIntType(-2);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Integer(-2), (Object)doc.getItemValueInteger(TEST_ITEM_NAME));
        instance.setTestIntType(2);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Integer(2), (Object)doc.getItemValueInteger(TEST_ITEM_NAME));
    }

    public void testMapIntegerClass() {
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestIntegerClass", Integer.class);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, new Integer(2));
        TestClass instance = new TestClass();
        this.map((Mapper)mapper, (DDocument)doc, instance);
        DirectMapperTest.assertEquals((Object)new Integer(2), (Object)instance.getTestIntegerClass());
        instance.setTestIntegerClass(new Integer(-2));
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Integer(-2), (Object)doc.getItemValueInteger(TEST_ITEM_NAME));
        instance.setTestIntegerClass(new Integer(2));
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Integer(2), (Object)doc.getItemValueInteger(TEST_ITEM_NAME));
    }

    public void testMapDoubleType() {
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestDoubleType", Double.TYPE);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, 2);
        TestClass instance = new TestClass();
        this.map((Mapper)mapper, (DDocument)doc, instance);
        DirectMapperTest.assertEquals((double)2.0, (double)instance.getTestDoubleType(), (double)1.0E-5);
        instance.setTestDoubleType(-2.3);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Double(-2.3), (Object)doc.getItemValueDouble(TEST_ITEM_NAME));
        instance.setTestDoubleType(2.1);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Double(2.1), (Object)doc.getItemValueDouble(TEST_ITEM_NAME));
    }

    public void testMapDoubleClass() {
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestDoubleClass", Double.class);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, new Double(2.0));
        TestClass instance = new TestClass();
        this.map((Mapper)mapper, (DDocument)doc, instance);
        DirectMapperTest.assertEquals((Object)new Double(2.0), (Object)instance.getTestDoubleClass());
        instance.setTestDoubleClass(new Double(-2.3));
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Double(-2.3), (Object)doc.getItemValueDouble(TEST_ITEM_NAME));
        instance.setTestDoubleClass(new Double(2.1));
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((Object)new Double(2.1), (Object)doc.getItemValueDouble(TEST_ITEM_NAME));
    }

    public void testMapBooleanType() {
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestBooleanType", Boolean.TYPE);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, "1");
        TestClass instance = new TestClass();
        instance.setTestBooleanType(false);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((String)"0", (String)doc.getItemValueString(TEST_ITEM_NAME));
        instance.setTestBooleanType(true);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((String)"1", (String)doc.getItemValueString(TEST_ITEM_NAME));
    }

    public void testMapBooleanClass() {
        DirectMapper mapper = this.getDirectMapper(TEST_ITEM_NAME, "TestBooleanClass", Boolean.class);
        MockDocument doc = new MockDocument();
        doc.replaceItemValue(TEST_ITEM_NAME, "1");
        TestClass instance = new TestClass();
        this.map((Mapper)mapper, (DDocument)doc, instance);
        DirectMapperTest.assertEquals((Object)Boolean.TRUE, (Object)instance.getTestBooleanClass());
        instance.setTestBooleanClass(Boolean.FALSE);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((String)"0", (String)doc.getItemValueString(TEST_ITEM_NAME));
        instance.setTestBooleanClass(Boolean.TRUE);
        this.map((Mapper)mapper, instance, (DDocument)doc);
        DirectMapperTest.assertEquals((String)"1", (String)doc.getItemValueString(TEST_ITEM_NAME));
    }

    private DirectMapper getDirectMapper(String itemName, String attributeName, Class clazz) {
        try {
            return new DirectMapper(itemName, attributeName, clazz);
        }
        catch (MethodNotFoundException e) {
            DirectMapperTest.fail((String)("Cannot create DirectMapper: " + e.getMessage()));
            return null;
        }
    }

    public static final class TestClass {
        private String fTestString;
        private List fTestList;
        private Collection fTestCollection;
        private Boolean fTestBooleanClass;
        private boolean fTestBoolean;
        private int fTestIntType;
        private Integer fTestIntegerClass;
        private double fTestDoubleType;
        private Double fTestDoubleClass;

        public List getTestList() {
            return this.fTestList;
        }

        public void setTestList(List testList) {
            this.fTestList = testList;
        }

        public String getTestString() {
            return this.fTestString;
        }

        public void setTestString(String testString) {
            this.fTestString = testString;
        }

        public Collection getTestCollection() {
            return this.fTestCollection;
        }

        public void setTestCollection(Collection testCollection) {
            this.fTestCollection = testCollection;
        }

        public int getTestIntType() {
            return this.fTestIntType;
        }

        public void setTestIntType(int testInt) {
            this.fTestIntType = testInt;
        }

        public Integer getTestIntegerClass() {
            return this.fTestIntegerClass;
        }

        public void setTestIntegerClass(Integer testInteger) {
            this.fTestIntegerClass = testInteger;
        }

        public Double getTestDoubleClass() {
            return this.fTestDoubleClass;
        }

        public void setTestDoubleClass(Double testDoubleClass) {
            this.fTestDoubleClass = testDoubleClass;
        }

        public double getTestDoubleType() {
            return this.fTestDoubleType;
        }

        public void setTestDoubleType(double testDoubleType) {
            this.fTestDoubleType = testDoubleType;
        }

        public boolean isTestBooleanType() {
            return this.fTestBoolean;
        }

        public void setTestBooleanType(boolean testBoolean) {
            this.fTestBoolean = testBoolean;
        }

        public Boolean getTestBooleanClass() {
            return this.fTestBooleanClass;
        }

        public void setTestBooleanClass(Boolean testBooleanClass) {
            this.fTestBooleanClass = testBooleanClass;
        }
    }
}

