/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.map;

import de.jakop.lotus.domingo.map.BaseMapperTest;
import de.jakop.lotus.domingo.map.NotesLocation;

public final class NotesLocationTest
extends BaseMapperTest {
    private Object password = "pwd";

    public void testInvalidLocation() {
        this.assertInvalidLocation("not:///");
        this.assertInvalidLocation("note://local!!names.nsf");
        this.assertInvalidLocation("notes://local!!names.nsf");
        this.assertInvalidLocation("notes:///user:pwd");
        this.assertInvalidLocation("local!!names.nsf");
        this.assertInvalidLocation("local!names.nsf");
        this.assertInvalidLocation("local!");
        this.assertInvalidLocation("notes:///user:@!!");
        this.assertInvalidLocation("notes:///user:pwd@!!");
        this.assertInvalidLocation("notes:///:pwd@sf.net!!names.nsf");
        this.assertInvalidLocation("http://");
    }

    public void testLocalLocation() {
        this.assertValidLocalLocation("notes:///", "", "");
        this.assertValidLocalLocation("notes:///!!names.nsf", "", "names.nsf");
        this.assertValidLocalLocation("notes:///local/", "", "");
        this.assertValidLocalLocation("notes:///local!!", "", "");
        this.assertValidLocalLocation("notes:///local", "", "");
        this.assertValidLocalLocation("notes:///lokal", "", "");
        this.assertValidLocalLocation("notes:///!!", "", "");
        this.assertValidLocalLocation("notes:///!!names.nsf", "", "names.nsf");
        this.assertValidLocalLocation("notes:///local!!names.nsf", "", "names.nsf");
        this.assertValidLocalLocation("notes:///lokal!!names.nsf", "", "names.nsf");
        this.assertValidLocalLocation("notes:///lokal!!test/test.nsf", "", "test/test.nsf");
        NotesLocationTest.assertFalse((String)"should not be a local location", (boolean)this.newLocation("notes:///lockal!!names.nsf").isLocal());
    }

    public void testServerLocation() {
        this.assertValidServerLocation("notes:///domingo.sf.net!!names.nsf", "domingo.sf.net", "names.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net!!test/test.nsf", "domingo.sf.net", "test/test.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net!!8525690D006AC34D", "domingo.sf.net", "8525690D006AC34D");
        this.assertValidServerLocation("notes:///domingo.sf.net!!__8525690D006AC34D.nsf", "domingo.sf.net", "__8525690D006AC34D.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net/names.nsf", "domingo.sf.net", "names.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net/test/test.nsf", "domingo.sf.net", "test/test.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net/test/test.nsf", "domingo.sf.net", "test/test.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net/test//test.nsf", "domingo.sf.net", "test//test.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net///test/test.nsf", "domingo.sf.net", "//test/test.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net/8525690D006AC34D", "domingo.sf.net", "8525690D006AC34D");
        this.assertValidServerLocation("notes:///domingo.sf.net/__8525690D006AC34D.nsf", "domingo.sf.net", "__8525690D006AC34D.nsf");
        this.assertValidServerLocation("notes:///domingo.sf.net", "domingo.sf.net", "");
        this.assertValidServerLocation("notes:///CN=PLATO/O=ACME!!names.nsf", "CN=PLATO/O=ACME", "names.nsf");
    }

    public void testIIOPLocation() {
        this.assertValidIIOPLocation("notes:///user:pwd@domingo.sf.net!!names.nsf", "domingo.sf.net", "names.nsf");
        this.assertValidIIOPLocation("notes:///user:pwd@domingo.sf.net!!8525690D006AC34D", "domingo.sf.net", "8525690D006AC34D");
        this.assertValidIIOPLocation("notes:///user:pwd@domingo.sf.net!!__8525690D006AC34D.nsf", "domingo.sf.net", "__8525690D006AC34D.nsf");
        this.assertValidIIOPLocation("notes:///user:pwd@domingo.sf.net/names.nsf", "domingo.sf.net", "names.nsf");
        this.assertValidIIOPLocation("notes:///user:pwd@domingo.sf.net/8525690D006AC34D", "domingo.sf.net", "8525690D006AC34D");
        this.assertValidIIOPLocation("notes:///user:pwd@domingo.sf.net/__8525690D006AC34D.nsf", "domingo.sf.net", "__8525690D006AC34D.nsf");
        this.assertValidIIOPLocation("notes:///user:pwd@127.0.0.1!!names.nsf", "127.0.0.1", "names.nsf");
        this.password = null;
        this.assertValidIIOPLocation("notes:///user:@127.0.0.1!!names.nsf", "127.0.0.1", "names.nsf");
        this.assertValidIIOPLocation("notes:///user:@127.0.0.1!!names.nsf", "127.0.0.1", "names.nsf");
        this.password = "pwd";
    }

    public void testHttpLocation() {
        this.assertValidIIOPLocation("http://user:pwd@sf.net", "sf.net", "");
    }

    public void testGetInstanceContext() {
        NotesLocation context = this.newLocation("notes:///!!names.nsf");
        this.assertValidLocalLocation(NotesLocation.getInstance((NotesLocation)context, (String)"", (String)"log.nsf"), "", "log.nsf");
        this.assertValidServerLocation(NotesLocation.getInstance((NotesLocation)context, (String)"sf.net", (String)"log.nsf"), "sf.net", "log.nsf");
        this.assertValidServerLocation(NotesLocation.getInstance((NotesLocation)context, (String)"sf.net", (String)"//log.nsf"), "sf.net", "//log.nsf");
    }

    public void testNotesLocationHierarchicalServerName() {
        NotesLocation nl = new NotesLocation("notes:///CN=SomeServer/OU=SVR/O=SomeOrg/C=US!!directory\\database.nsf");
        NotesLocationTest.assertEquals((String)"CN=SomeServer/OU=SVR/O=SomeOrg/C=US", (String)nl.getServer());
        NotesLocationTest.assertEquals((String)"directory\\database.nsf", (String)nl.getPath());
    }

    private void assertValidLocalLocation(String locationString, String server, String path) {
        this.assertValidLocalLocation(this.newLocation(locationString), server, path);
    }

    private void assertValidLocalLocation(NotesLocation location, String server, String path) {
        NotesLocationTest.assertTrue((String)"Should be a local location", (boolean)location.isLocal());
        NotesLocationTest.assertFalse((String)"Should be a local location", (boolean)location.isIIOP());
        NotesLocationTest.assertEquals((String)"wrong server", (String)server, (String)location.getServer());
        NotesLocationTest.assertEquals((String)"wrong path", (String)path, (String)location.getPath());
        NotesLocationTest.assertNull((String)"username should be null", (Object)location.getUsername());
        NotesLocationTest.assertNull((String)"passwordshould be null", (Object)location.getPassword());
    }

    private void assertValidServerLocation(String locationString, String server, String path) {
        this.assertValidServerLocation(this.newLocation(locationString), server, path);
    }

    private void assertValidServerLocation(NotesLocation location, String server, String path) {
        NotesLocationTest.assertFalse((String)"Should be a local location", (boolean)location.isLocal());
        NotesLocationTest.assertFalse((String)"Should be a local location", (boolean)location.isIIOP());
        NotesLocationTest.assertEquals((String)"wrong server", (String)server, (String)location.getServer());
        NotesLocationTest.assertEquals((String)"wrong path", (String)path, (String)location.getPath());
    }

    private void assertValidIIOPLocation(String locationString, String host, String path) {
        NotesLocation location = this.newLocation(locationString);
        NotesLocationTest.assertFalse((String)"Should be an IIOP location", (boolean)location.isLocal());
        NotesLocationTest.assertTrue((String)"Should be an IIOP location", (boolean)location.isIIOP());
        NotesLocationTest.assertEquals((String)"wrong host", (String)host, (String)location.getHost());
        NotesLocationTest.assertEquals((String)"wrong path", (String)path, (String)location.getPath());
        NotesLocationTest.assertEquals((String)"wrong username", (String)"user", (String)location.getUsername());
        NotesLocationTest.assertEquals((String)"wrong password", (Object)this.password, (Object)location.getPassword());
    }

    private void assertInvalidLocation(String locationString) {
        try {
            new NotesLocation(locationString);
        }
        catch (RuntimeException e) {
            return;
        }
        NotesLocationTest.fail((String)"location is unexpectedly valid");
    }

    private NotesLocation newLocation(String locationString) {
        try {
            return new NotesLocation(locationString);
        }
        catch (RuntimeException e) {
            this.fail("Location should be valid", e);
            return null;
        }
    }
}

