/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.samples;

import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DNotesFactory;
import de.jakop.lotus.domingo.DNotesMonitor;
import de.jakop.lotus.domingo.DRichTextItem;
import de.jakop.lotus.domingo.DSession;
import de.jakop.lotus.domingo.monitor.ConsoleMonitor;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class CorbaCreateManyDocuments {
    public static final void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Arguments: host username password");
            return;
        }
        DDatabase database = null;
        try {
            ConsoleMonitor monitor = new ConsoleMonitor();
            monitor.setLevel(50);
            DNotesFactory factory = DNotesFactory.getInstance((DNotesMonitor)monitor);
            DSession session = factory.getSession(args[0], args[1], args[2]);
            database = session.createDatabase("", "testCorbaCreateManyDocuments.nsf");
            monitor.debug("Database many.nsf created on server " + args[0]);
            for (int i = 0; i < 30; ++i) {
                for (int j = 0; j < 1000; ++j) {
                    DDocument document = database.createDocument();
                    document.replaceItemValue("Form", "Test");
                    document.replaceItemValue("Test", "Test");
                    document.replaceItemValue("Number", 1.1234);
                    document.replaceItemValue("Date", (Calendar)new GregorianCalendar(2007, 1, 1, 17, 30, 0));
                    DRichTextItem item = document.createRichTextItem("Body");
                    item.appendText("some rich text");
                    item.addNewLine(2);
                    item.appendText("some more text");
                    document.save();
                }
                monitor.debug("Created " + (i + 1) * 1000 + " documents");
            }
            monitor.debug("finished successfully.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (database != null) {
            database.remove();
        }
    }
}

