/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.samples.groupware;

import de.jakop.lotus.domingo.DNotesMonitor;
import de.jakop.lotus.domingo.groupware.AddressBook;
import de.jakop.lotus.domingo.groupware.CalendarEntry;
import de.jakop.lotus.domingo.groupware.CalendarInterface;
import de.jakop.lotus.domingo.groupware.ContactDigest;
import de.jakop.lotus.domingo.groupware.Email;
import de.jakop.lotus.domingo.groupware.EmailDigest;
import de.jakop.lotus.domingo.groupware.Groupware;
import de.jakop.lotus.domingo.groupware.GroupwareException;
import de.jakop.lotus.domingo.groupware.Mailbox;
import de.jakop.lotus.domingo.monitor.ConsoleMonitor;
import java.util.Iterator;

public class GroupwareSample {
    private static final int MAX_MAILS = 10;
    private static final int MAX_CONTACTS = 10;

    public static void main(String[] args) {
        GroupwareSample sample = new GroupwareSample();
        try {
            sample.run();
        }
        catch (GroupwareException e) {
            e.printStackTrace();
        }
    }

    private void run() throws GroupwareException {
        ConsoleMonitor monitor = new ConsoleMonitor();
        monitor.setLevel(50);
        Groupware groupware = new Groupware("notes:///local/", (DNotesMonitor)monitor);
        Mailbox mailbox = groupware.getMailbox();
        CalendarInterface calendar = groupware.getCalendar();
        Iterator addressbooks = groupware.getAddressBooks();
        while (addressbooks.hasNext()) {
            System.out.println("---");
            AddressBook ab = (AddressBook)addressbooks.next();
            System.out.println("Title: " + ab.getTitle() + " Private? " + ab.isPrivate() + " Public? " + ab.isPublic());
            Iterator contacts = ab.getContacts();
            if (!contacts.hasNext()) {
                System.out.println("no contacts found");
                continue;
            }
            System.out.println("Printing first 10 entries");
            int i = 0;
            while (contacts.hasNext() && i < 10) {
                ContactDigest c = (ContactDigest)contacts.next();
                System.out.println(++i + ". " + c.getFullName() + " " + c.getEmail());
            }
        }
        System.out.println("---");
        Iterator inbox = mailbox.getInbox();
        int i = 0;
        while (inbox.hasNext() && i++ < 10) {
            EmailDigest emailDigest = (EmailDigest)inbox.next();
            System.out.println(emailDigest.toString());
        }
        System.out.println("---");
        Email email = new Email();
        email.setSubject("Test");
        email.setRecipient("kriede@users.sourceforge.net");
        email.setBody("Hello world!");
        mailbox.send(email);
        System.out.println("Email sent");
        CalendarEntry entry = new CalendarEntry();
        entry.setTitle("New Years Party");
        entry.setStartDate(2006, 11, 31);
        entry.setStartTime(20, 0, 0);
        entry.setEndDate(2007, 0, 1);
        entry.setEndTime(5, 0, 0);
        calendar.save(entry);
        System.out.println("Appointment created");
    }
}

