/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.util;

import de.jakop.lotus.domingo.util.DateUtil;
import de.jakop.lotus.domingo.util.DeepCopy;
import de.jakop.lotus.domingo.util.GregorianDate;
import de.jakop.lotus.domingo.util.GregorianDateTime;
import de.jakop.lotus.domingo.util.GregorianTime;
import de.jakop.lotus.domingo.util.GregorianTimeZone;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;

public final class GregorianTest
extends TestCase {
    private static final String SAMPLE_DATE_STRING = "2007-07-31 23:59:58";

    public GregorianTest(String name) {
        super(name);
    }

    public void testGregorian() {
        GregorianDate date1 = new GregorianDate(2004, 6, 31);
        GregorianTime time1 = new GregorianTime(17, 30, 15);
        this.assertDate((Calendar)date1);
        this.assertTime((Calendar)time1);
        date1.set(1, 2005);
        time1.set(10, 19);
        this.assertDate((Calendar)date1);
        this.assertTime((Calendar)time1);
        GregorianDate date2 = new GregorianDate((Calendar)date1);
        GregorianTime time2 = new GregorianTime((Calendar)time1);
        time2.set(1, 1999);
        time2.set(2, 0);
        time2.set(5, 1);
        date2.set(10, 19);
        date2.set(12, 19);
        date2.set(13, 19);
        GregorianTest.assertEquals((Object)date1, (Object)date2);
        GregorianTest.assertEquals((Object)time1, (Object)time2);
    }

    private void assertTime(Calendar time) {
        time.get(1);
        time.get(10);
        time.get(14);
        GregorianTest.assertFalse((String)"Time has a date field set", (boolean)time.isSet(1));
        GregorianTest.assertFalse((String)"Time has a date field set", (boolean)time.isSet(2));
        GregorianTest.assertFalse((String)"Time has a date field set", (boolean)time.isSet(5));
    }

    private void assertDate(Calendar date) {
        date.get(1);
        date.get(10);
        date.get(14);
        GregorianTest.assertFalse((String)"Date has a time field set", (boolean)date.isSet(11));
        GregorianTest.assertFalse((String)"Date has a time field set", (boolean)date.isSet(12));
        GregorianTest.assertFalse((String)"Date has a time field set", (boolean)date.isSet(13));
    }

    public void testGregorianTimeSetTimeInMillis() {
        GregorianTime time1 = new GregorianTime();
        GregorianTime time2 = new GregorianTime();
        long timeInMillis = time1.getTimeInMillis();
        time1.setTimeInMillis(timeInMillis + 1L);
        GregorianTest.assertEquals((Object)time1, (Object)time2);
        GregorianTest.assertEquals((long)time1.getTimeInMillis(), (long)time2.getTimeInMillis());
    }

    public void testGregorianTimeSetTime() {
        Date date = new Date();
        GregorianTime time1 = new GregorianTime(date);
        GregorianTime time2 = new GregorianTime(date);
        time1.setTime(new Date(date.getTime() + 1L));
        GregorianTest.assertEquals((Object)time1, (Object)time2);
        GregorianTest.assertEquals((long)time1.getTimeInMillis(), (long)time2.getTimeInMillis());
    }

    public void testGregorianTimeSetTimeZone() {
        Date date = new Date();
        GregorianTime time1 = new GregorianTime(date);
        GregorianTime time2 = new GregorianTime(date);
        time1.setTimeZone(TimeZone.getTimeZone("GMT+5"));
        GregorianTest.assertEquals((Object)time1, (Object)time2);
        GregorianTest.assertEquals((Object)time2, (Object)time1);
        GregorianTest.assertEquals((long)time1.getTimeInMillis(), (long)time2.getTimeInMillis());
    }

    public void testGregorianDateSetTimeInMillis() {
        GregorianDate date1 = new GregorianDate();
        GregorianDate date2 = new GregorianDate();
        long timeInMillis = date1.getTimeInMillis();
        date1.setTimeInMillis(timeInMillis + 1L);
        GregorianTest.assertEquals((Object)date1, (Object)date2);
        GregorianTest.assertEquals((long)date1.getTimeInMillis(), (long)date2.getTimeInMillis());
    }

    public void testGregorianDateSetTime() {
        Date date = new Date();
        GregorianDate date1 = new GregorianDate(date);
        GregorianDate date2 = new GregorianDate(date);
        date1.setTime(new Date(date.getTime() + 1L));
        GregorianTest.assertEquals((Object)date1, (Object)date2);
        GregorianTest.assertEquals((long)date1.getTimeInMillis(), (long)date2.getTimeInMillis());
    }

    public void testGregorianDateSetTimeZone() {
        Date date = new Date();
        GregorianDate date1 = new GregorianDate(date);
        GregorianDate date2 = new GregorianDate(date);
        date1.setTimeZone(TimeZone.getTimeZone("GMT+5"));
        GregorianTest.assertEquals((Object)date1, (Object)date2);
        GregorianTest.assertEquals((long)date1.getTimeInMillis(), (long)date2.getTimeInMillis());
    }

    public void testCreateGregorian() {
        GregorianDate calendar = new GregorianDate(2005, 0, 31);
        GregorianTest.assertEquals((int)2005, (int)calendar.get(1));
        GregorianTest.assertEquals((int)1, (int)(calendar.get(2) + 1));
        GregorianTest.assertEquals((int)31, (int)calendar.get(5));
        calendar = new GregorianTime(15, 37, 48);
        GregorianTest.assertEquals((int)15, (int)calendar.get(11));
        GregorianTest.assertEquals((int)37, (int)calendar.get(12));
        GregorianTest.assertEquals((int)48, (int)calendar.get(13));
        calendar = new GregorianDateTime(2005, 0, 31, 15, 37, 48);
        GregorianTest.assertEquals((int)2005, (int)calendar.get(1));
        GregorianTest.assertEquals((int)1, (int)(calendar.get(2) + 1));
        GregorianTest.assertEquals((int)31, (int)calendar.get(5));
        GregorianTest.assertEquals((int)15, (int)calendar.get(11));
        GregorianTest.assertEquals((int)37, (int)calendar.get(12));
        GregorianTest.assertEquals((int)48, (int)calendar.get(13));
    }

    public void testCloneGregorianDate() {
        GregorianDate c1 = new GregorianDate(2007, 0, 1);
        Calendar c2 = (Calendar)c1.clone();
        this.assertDate((Calendar)c1);
        this.assertDate(c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testCopyGregorianDate() {
        GregorianDate c1 = new GregorianDate(2007, 0, 1);
        this.assertDate((Calendar)c1);
        GregorianDate c2 = new GregorianDate((Calendar)c1);
        this.assertDate((Calendar)c1);
        this.assertDate((Calendar)c1);
        this.assertDate((Calendar)c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testFromCalendarGregorianDate() {
        Calendar base = Calendar.getInstance();
        GregorianDate c1 = new GregorianDate(base.get(1), base.get(2), base.get(5));
        GregorianDate c2 = new GregorianDate(base);
        this.assertDate((Calendar)c1);
        this.assertDate((Calendar)c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testFromStringGregorianDate() {
        GregorianDate base = new GregorianDate(DateUtil.parseDate((String)SAMPLE_DATE_STRING, (boolean)false));
        GregorianDate c1 = new GregorianDate((Calendar)base);
        GregorianDate c2 = new GregorianDate(base.get(1), base.get(2), base.get(5));
        this.assertDate((Calendar)c1);
        this.assertDate((Calendar)c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testFromSerializedGregorianDate() {
        GregorianDate base = new GregorianDate(DateUtil.parseDate((String)SAMPLE_DATE_STRING, (boolean)false));
        GregorianDate c1 = new GregorianDate((Calendar)base);
        Calendar c2 = (Calendar)DeepCopy.copy(c1);
        this.assertDate((Calendar)c1);
        this.assertDate(c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testCloneGregorianTime() {
        GregorianTime c1 = new GregorianTime(11, 12, 13);
        Calendar c2 = (Calendar)c1.clone();
        this.assertTime((Calendar)c1);
        this.assertTime(c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testCopyGregorianTime() {
        GregorianTime c1 = new GregorianTime(11, 12, 13);
        GregorianTime c2 = new GregorianTime((Calendar)c1);
        this.assertTime((Calendar)c1);
        this.assertTime((Calendar)c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testFromCalendarGregorianTime() {
        Calendar base = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        GregorianTime c1 = new GregorianTime(base.get(11), base.get(12), base.get(13));
        GregorianTime c2 = new GregorianTime(base);
        this.assertTime((Calendar)c1);
        this.assertTime((Calendar)c2);
        GregorianTest.assertEquals((int)c1.get(11), (int)c2.get(11));
        GregorianTest.assertEquals((int)c1.get(12), (int)c2.get(12));
        GregorianTest.assertEquals((int)c1.get(13), (int)c2.get(13));
    }

    public void testFromStringGregorianTime() {
        GregorianTime base = new GregorianTime(DateUtil.parseDate((String)SAMPLE_DATE_STRING, (boolean)false));
        GregorianTime c1 = new GregorianTime((Calendar)base);
        GregorianTime c2 = new GregorianTime(base.get(11), base.get(12), base.get(13));
        this.assertTime((Calendar)c1);
        this.assertTime((Calendar)c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testFromSerializedGregorianTime() {
        GregorianTime base = new GregorianTime(DateUtil.parseDate((String)SAMPLE_DATE_STRING, (boolean)false));
        GregorianTime c1 = new GregorianTime((Calendar)base);
        Calendar c2 = (Calendar)DeepCopy.copy(c1);
        this.assertTime((Calendar)c1);
        this.assertTime(c2);
        GregorianTest.assertEquals((Object)c1, (Object)c2);
    }

    public void testEqualsGregorianTimezone() {
        GregorianTimeZone tz1 = new GregorianTimeZone();
        GregorianTimeZone tz2 = new GregorianTimeZone();
        GregorianTest.assertEquals((Object)tz1, (Object)tz2);
        GregorianTest.assertFalse((tz1 == tz2 ? 1 : 0) != 0);
        tz1 = new GregorianTimeZone(TimeZone.getTimeZone("GMT"));
        tz2 = new GregorianTimeZone(TimeZone.getTimeZone("GMT"));
        GregorianTest.assertEquals((Object)tz1, (Object)tz2);
        GregorianTest.assertFalse((tz1 == tz2 ? 1 : 0) != 0);
        tz1.setTimeZone(TimeZone.getTimeZone("GMT"));
        tz2.setTimeZone(TimeZone.getTimeZone("PST"));
        GregorianTest.assertFalse((boolean)tz1.equals((Object)tz2));
    }
}

