/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo.util;

import de.jakop.lotus.domingo.util.Timezones;
import java.util.TimeZone;
import junit.framework.TestCase;

public final class TimezonesTest
extends TestCase {
    public TimezonesTest(String name) {
        super(name);
    }

    public void testTimezoneEuropeBerlinString() {
        String javaTimeZone = "Europe/Berlin";
        String lotusTimeZone = Timezones.getLotusTimeZoneString((String)javaTimeZone);
        System.out.println("Lotus time zone for '" + javaTimeZone + "' = '" + lotusTimeZone + "'");
        TimezonesTest.assertEquals((String)"Z=-1$DO=1$DL=3 -1 1 10 -1 1$ZX=70$ZN=W. Europe", (String)lotusTimeZone);
    }

    public void testTimezoneUSPacificString() {
        String javaTimeZone = "US/Pacific";
        String lotusTimeZone = Timezones.getLotusTimeZoneString((String)javaTimeZone);
        System.out.println("Lotus time zone for '" + javaTimeZone + "' = '" + lotusTimeZone + "'");
        TimezonesTest.assertEquals((String)"Z=8$DO=1$DL=3 2 1 11 1 1$ZX=61$ZN=Pacific", (String)lotusTimeZone);
    }

    public void testTimezoneEuropeBerlinTimeZone() {
        TimeZone javaTimeZone = TimeZone.getTimeZone("Europe/Berlin");
        String lotusTimeZone = Timezones.getLotusTimeZoneString((TimeZone)javaTimeZone);
        System.out.println("Lotus time zone for '" + javaTimeZone + "' = '" + lotusTimeZone + "'");
        TimezonesTest.assertEquals((String)"Z=-1$DO=1$DL=3 -1 1 10 -1 1$ZX=70$ZN=W. Europe", (String)lotusTimeZone);
    }

    public void testTimezoneUSPacificTimeZone() {
        TimeZone javaTimeZone = TimeZone.getTimeZone("US/Pacific");
        String lotusTimeZone = Timezones.getLotusTimeZoneString((TimeZone)javaTimeZone);
        System.out.println("Lotus time zone for '" + javaTimeZone + "' = '" + lotusTimeZone + "'");
        TimezonesTest.assertEquals((String)"Z=8$DO=1$DL=3 2 1 11 1 1$ZX=61$ZN=Pacific", (String)lotusTimeZone);
    }

    public void testTimezoneUnknown() {
        String javaTimeZone = "Unknown";
        try {
            Timezones.getLotusTimeZoneString((String)javaTimeZone);
        }
        catch (NullPointerException e) {
            TimezonesTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            return;
        }
        TimezonesTest.fail((String)"IllegalArgumentException expected");
    }

    public void testTimezoneNullString() {
        String javaTimeZone = null;
        try {
            Timezones.getLotusTimeZoneString(javaTimeZone);
        }
        catch (NullPointerException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            TimezonesTest.fail((String)"NullPointerException expected");
        }
        TimezonesTest.fail((String)"NullPointerException expected");
    }

    public void testTimezoneEmptyString() {
        String javaTimeZone = "";
        try {
            Timezones.getLotusTimeZoneString((String)javaTimeZone);
        }
        catch (NullPointerException e) {
            TimezonesTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            return;
        }
        TimezonesTest.fail((String)"IllegalArgumentException expected");
    }

    public void testTimezoneNullTimezone() {
        TimeZone javaTimeZone = null;
        try {
            Timezones.getLotusTimeZoneString(javaTimeZone);
        }
        catch (NullPointerException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            TimezonesTest.fail((String)"NullPointerException expected");
        }
        TimezonesTest.fail((String)"NullPointerException expected");
    }
}

