/*
 * Decompiled with CFR 0.152.
 */
package de.jamba.hudson.plugin.wsclean;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.remoting.RequestAbortedException;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrePostClean
extends BuildWrapper {
    public boolean before;
    private boolean behind;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public boolean isBefore() {
        return this.before;
    }

    public void setBefore(boolean before) {
        this.before = before;
        this.behind = !before;
    }

    @DataBoundConstructor
    public PrePostClean(boolean before) {
        this.before = before;
        this.behind = !before;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.before) {
            this.executeOnSlaves(build, listener);
        }
        class TearDownImpl
        extends BuildWrapper.Environment {
            TearDownImpl() {
                super((BuildWrapper)PrePostClean.this);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (PrePostClean.this.behind) {
                    PrePostClean.this.executeOnSlaves(build, listener);
                }
                return super.tearDown(build, listener);
            }
        }
        return new TearDownImpl();
    }

    private void executeOnSlaves(AbstractBuild build, BuildListener listener) {
        listener.getLogger().println("run PrePostClean");
        String runNode = build.getBuiltOnStr();
        if (runNode.length() == 0) {
            listener.getLogger().println("running on master");
        } else {
            listener.getLogger().println("running on " + runNode);
        }
        Set usedNodes = build.getProject().getAssignedLabel().getNodes();
        if (usedNodes != null) {
            for (Node node : usedNodes) {
                if (runNode.equals(node.getNodeName())) continue;
                if (node.getNodeName().length() == 0) {
                    listener.getLogger().println("clean on master");
                    this.deleteOnMaster(build, listener);
                    continue;
                }
                listener.getLogger().println("clean on " + node.getNodeName());
                this.deleteRemote(build, listener, node);
            }
        }
    }

    private void deleteOnMaster(AbstractBuild build, BuildListener listener) {
        if (Hudson.getInstance().getNumExecutors() > 0) {
            FilePath fp = new FilePath(new File(Hudson.getInstance().getRootPath() + "/jobs/" + build.getProject().getName() + "/workspace"));
            try {
                fp.deleteContents();
            }
            catch (IOException e) {
                listener.getLogger().println("cat delete on Master " + e.getMessage());
                listener.getLogger().print(e);
            }
            catch (InterruptedException e) {
                listener.getLogger().println("cat delete on Master " + e.getMessage());
                listener.getLogger().print(e);
            }
        }
    }

    private void deleteRemote(AbstractBuild build, BuildListener listener, Node node) {
        VirtualChannel vc = ((Slave)node).getComputer().getChannel();
        if (!((Slave)node).getComputer().isConnecting() && !((Slave)node).getComputer().isTemporarilyOffline()) {
            ((Slave)node).getComputer().connect(true);
            int i = 0;
            while (vc == null && ++i < 120) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    listener.getLogger().println(e.getMessage());
                }
                vc = ((Slave)node).getComputer().getChannel();
            }
        }
        if (vc != null) {
            FilePath fp = new FilePath(vc, ((Slave)node).getRemoteFS() + "/workspace/" + build.getProject().getName());
            try {
                fp.deleteContents();
            }
            catch (IOException e) {
                listener.getLogger().println("cat delete on Slave " + e.getMessage());
                listener.getLogger().print(e);
            }
            catch (InterruptedException e) {
                listener.getLogger().println("cat delete on Slave " + e.getMessage());
                listener.getLogger().print(e);
            }
            catch (RequestAbortedException e) {
                listener.getLogger().println("cat delete on Slave " + e.getMessage());
            }
        } else {
            listener.getLogger().println("no deleteChannel on " + node.getNodeName());
        }
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        DescriptorImpl() {
            super(PrePostClean.class);
        }

        public String getDisplayName() {
            return "CleanUp all other workspaces in the same slavegroup";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

