/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.math.AbstractNumber;
import de.jfachwert.math.Prozent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Period;
import java.util.Map;
import java.util.WeakHashMap;
import javax.money.MonetaryAmount;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001e2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0019\u001a\u00020\bH\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lde/jfachwert/bank/Zinssatz;", "Lde/jfachwert/KFachwert;", "", "prozent", "Lde/jfachwert/math/Prozent;", "<init>", "(Lde/jfachwert/math/Prozent;)V", "satz", "", "(Ljava/lang/String;)V", "getProzent", "()Lde/jfachwert/math/Prozent;", "getJahresszins", "Ljavax/money/MonetaryAmount;", "kapital", "getMonatszins", "getTageszins", "getZinsen", "dauer", "Ljava/time/Period;", "getEndkapital", "startKapital", "compareTo", "", "other", "toString", "equals", "", "", "hashCode", "Companion", "bank"})
public class Zinssatz
implements KFachwert,
Comparable<Zinssatz> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Prozent prozent;
    @NotNull
    private static final WeakHashMap<Prozent, Zinssatz> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Zinssatz ZERO = Companion.of(Prozent.ZERO);
    @JvmField
    @NotNull
    public static final Zinssatz ONE = Companion.of(Prozent.ONE);
    @JvmField
    @NotNull
    public static final Zinssatz TEN = Companion.of(Prozent.TEN);

    public Zinssatz(@NotNull Prozent prozent) {
        Intrinsics.checkNotNullParameter((Object)prozent, (String)"prozent");
        this.prozent = prozent;
    }

    @NotNull
    public final Prozent getProzent() {
        return this.prozent;
    }

    public Zinssatz(@NotNull String satz) {
        Intrinsics.checkNotNullParameter((Object)satz, (String)"satz");
        this(Prozent.Companion.of(satz));
    }

    @NotNull
    public final MonetaryAmount getJahresszins(@NotNull MonetaryAmount kapital) {
        Intrinsics.checkNotNullParameter((Object)kapital, (String)"kapital");
        return this.prozent.multiply(kapital);
    }

    @NotNull
    public final MonetaryAmount getMonatszins(@NotNull MonetaryAmount kapital) {
        Intrinsics.checkNotNullParameter((Object)kapital, (String)"kapital");
        MonetaryAmount monetaryAmount = this.prozent.multiply(kapital).divide(12L);
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"divide(...)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount getTageszins(@NotNull MonetaryAmount kapital) {
        Intrinsics.checkNotNullParameter((Object)kapital, (String)"kapital");
        MonetaryAmount monetaryAmount = this.prozent.multiply(kapital).divide(360L);
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"divide(...)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount getZinsen(@NotNull MonetaryAmount kapital, @NotNull Period dauer) {
        Intrinsics.checkNotNullParameter((Object)kapital, (String)"kapital");
        Intrinsics.checkNotNullParameter((Object)dauer, (String)"dauer");
        MonetaryAmount monetaryAmount = this.getEndkapital(kapital, dauer).subtract(kapital);
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"subtract(...)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount getEndkapital(@NotNull MonetaryAmount startKapital, @NotNull Period dauer) {
        Intrinsics.checkNotNullParameter((Object)startKapital, (String)"startKapital");
        Intrinsics.checkNotNullParameter((Object)dauer, (String)"dauer");
        Period normalized = dauer.normalized();
        BigDecimal faktor = this.prozent.toBigDecimal().add(BigDecimal.ONE);
        MonetaryAmount endKapital = startKapital.multiply((Number)faktor.pow(normalized.getYears()).setScale(startKapital.getContext().getMaxScale(), RoundingMode.HALF_UP));
        Intrinsics.checkNotNull((Object)endKapital);
        MonetaryAmount monetaryAmount = endKapital.add(this.getMonatszins(endKapital).multiply((Number)normalized.getMonths())).add(this.getTageszins(endKapital).multiply((Number)normalized.getDays()));
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"add(...)");
        return monetaryAmount;
    }

    @Override
    public int compareTo(@NotNull Zinssatz other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.prozent.compareTo((AbstractNumber)other.prozent);
    }

    @NotNull
    public String toString() {
        return this.prozent.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Zinssatz)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.prozent, (Object)((Zinssatz)other).prozent);
    }

    public int hashCode() {
        return this.prozent.hashCode();
    }

    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap((KFachwert)this);
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final Zinssatz of(@NotNull String satz) {
        return Companion.of(satz);
    }

    @JvmStatic
    @NotNull
    public static final Zinssatz of(@NotNull Prozent satz) {
        return Companion.of(satz);
    }

    @JvmStatic
    @NotNull
    public static final Zinssatz of(@NotNull MonetaryAmount kapital, @NotNull MonetaryAmount zins, long monate) {
        return Companion.of(kapital, zins, monate);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0007J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/jfachwert/bank/Zinssatz$Companion;", "", "<init>", "()V", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/math/Prozent;", "Lde/jfachwert/bank/Zinssatz;", "ZERO", "ONE", "TEN", "of", "satz", "", "kapital", "Ljavax/money/MonetaryAmount;", "zins", "monate", "", "bank"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Zinssatz of(@NotNull String satz) {
            Intrinsics.checkNotNullParameter((Object)satz, (String)"satz");
            return this.of(Prozent.Companion.of(satz));
        }

        @JvmStatic
        @NotNull
        public final Zinssatz of(@NotNull Prozent satz) {
            Intrinsics.checkNotNullParameter((Object)satz, (String)"satz");
            Zinssatz zinssatz = WEAK_CACHE.computeIfAbsent(satz, Zinssatz::new);
            Intrinsics.checkNotNullExpressionValue((Object)zinssatz, (String)"computeIfAbsent(...)");
            return zinssatz;
        }

        @JvmStatic
        @NotNull
        public final Zinssatz of(@NotNull MonetaryAmount kapital, @NotNull MonetaryAmount zins, long monate) {
            Intrinsics.checkNotNullParameter((Object)kapital, (String)"kapital");
            Intrinsics.checkNotNullParameter((Object)zins, (String)"zins");
            Number number = kapital.getNumber().numberValue(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue((Object)number, (String)"numberValue(...)");
            BigDecimal k = (BigDecimal)number;
            Number number2 = zins.getNumber().numberValue(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue((Object)number2, (String)"numberValue(...)");
            BigDecimal z = (BigDecimal)number2;
            BigDecimal bigDecimal = z.divide(k).multiply(BigDecimal.valueOf(1200L).divide(BigDecimal.valueOf(monate)));
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
            BigDecimal p = bigDecimal;
            return this.of(Prozent.Companion.of(p));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

