/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert;

import de.jfachwert.Fachwert;
import de.jfachwert.Text;
import de.jfachwert.bank.BIC;
import de.jfachwert.bank.BLZ;
import de.jfachwert.bank.Bankverbindung;
import de.jfachwert.bank.IBAN;
import de.jfachwert.bank.Kontonummer;
import de.jfachwert.math.Bruch;
import de.jfachwert.math.Nummer;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.net.ChatAccount;
import de.jfachwert.net.Domainname;
import de.jfachwert.net.EMailAdresse;
import de.jfachwert.net.Telefonnummer;
import de.jfachwert.post.Adressat;
import de.jfachwert.post.Adresse;
import de.jfachwert.post.Anschrift;
import de.jfachwert.post.Ort;
import de.jfachwert.post.PLZ;
import de.jfachwert.post.Postfach;
import de.jfachwert.rechnung.Artikelnummer;
import de.jfachwert.rechnung.Bestellnummer;
import de.jfachwert.rechnung.Kundennummer;
import de.jfachwert.rechnung.Rechnungsmonat;
import de.jfachwert.rechnung.Rechnungsnummer;
import de.jfachwert.rechnung.Referenznummer;
import de.jfachwert.steuer.SteuerIdNr;
import de.jfachwert.steuer.Steuernummer;
import de.jfachwert.steuer.UStIdNr;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ValidationException;

public class FachwertFactory {
    private static final FachwertFactory INSTANCE = new FachwertFactory();
    private final Map<String, Class<? extends Fachwert>> registeredClasses = new HashMap<String, Class<? extends Fachwert>>();
    private static final Logger LOG = Logger.getLogger(Fachwert.class.getName());

    private FachwertFactory() {
    }

    public static FachwertFactory getInstance() {
        return INSTANCE;
    }

    public synchronized void register(Class<? extends Fachwert> fachwertClass) {
        this.registeredClasses.put(fachwertClass.getSimpleName(), fachwertClass);
    }

    public Map<String, Class<? extends Fachwert>> getRegisteredClasses() {
        return this.registeredClasses;
    }

    public Fachwert getFachwert(String name, Object ... args) {
        Class<? extends Fachwert> fachwertClass = this.getClassFor(name);
        return this.getFachwert(fachwertClass, args);
    }

    public Fachwert getFachwert(Class<? extends Fachwert> clazz, Object ... args) {
        Class[] argTypes = FachwertFactory.toTypes(args);
        try {
            Constructor<? extends Fachwert> ctor = clazz.getConstructor(argTypes);
            return ctor.newInstance(args);
        }
        catch (ReflectiveOperationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ValidationException) {
                throw (ValidationException)cause;
            }
            throw new IllegalArgumentException("cannot create " + clazz + " with " + Arrays.toString(args), ex);
        }
    }

    public void validate(String name, Object ... args) {
        Class<? extends Fachwert> fachwertClass = this.getClassFor(name);
        this.validate(fachwertClass, args);
    }

    public void validate(Class<? extends Fachwert> clazz, Object ... args) {
        Class[] argTypes = FachwertFactory.toTypes(args);
        try {
            Method method = clazz.getMethod("validate", argTypes);
            method.invoke(null, args);
        }
        catch (InvocationTargetException ex) {
            LOG.log(Level.FINE, "Call of validate method of " + clazz + "failed:", ex);
            if (ex.getTargetException() instanceof ValidationException) {
                throw (ValidationException)ex.getTargetException();
            }
            this.getFachwert(clazz, args);
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.FINE, "Cannot call validate method of " + clazz, ex);
            this.getFachwert(clazz, args);
        }
    }

    private Class<? extends Fachwert> getClassFor(String name) {
        Class<? extends Fachwert> fachwertClass = this.registeredClasses.get(name);
        if (fachwertClass == null) {
            fachwertClass = this.registeredClasses.get(this.getSimilarName(name));
        }
        return fachwertClass;
    }

    private static Class[] toTypes(Object[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return argTypes;
    }

    private String getSimilarName(String name) {
        String similarName = "?";
        int minDistance = Integer.MAX_VALUE;
        for (String registeredName : this.registeredClasses.keySet()) {
            int dist = FachwertFactory.distance(name, registeredName);
            if (dist >= minDistance) continue;
            similarName = registeredName;
            minDistance = dist;
        }
        if (minDistance > 2) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Nearest name for '" + name + "' is '" + similarName + "' and too far away (" + minDistance + ") - will use Text class as fallback.");
            }
            similarName = Text.class.getSimpleName();
        }
        return similarName;
    }

    private static int distance(String a, String b) {
        a = a.toLowerCase();
        b = b.toLowerCase();
        int[] costs = new int[b.length() + 1];
        for (int j = 0; j < costs.length; ++j) {
            costs[j] = j;
        }
        for (int i = 1; i <= a.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= b.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[b.length()];
    }

    static {
        INSTANCE.register(Text.class);
        INSTANCE.register(Nummer.class);
        INSTANCE.register(Bankverbindung.class);
        INSTANCE.register(BIC.class);
        INSTANCE.register(BLZ.class);
        INSTANCE.register(IBAN.class);
        INSTANCE.register(Kontonummer.class);
        INSTANCE.register(ChatAccount.class);
        INSTANCE.register(Domainname.class);
        INSTANCE.register(EMailAdresse.class);
        INSTANCE.register(Telefonnummer.class);
        INSTANCE.register(Adressat.class);
        INSTANCE.register(Adresse.class);
        INSTANCE.register(Anschrift.class);
        INSTANCE.register(Ort.class);
        INSTANCE.register(PLZ.class);
        INSTANCE.register(Postfach.class);
        INSTANCE.register(Artikelnummer.class);
        INSTANCE.register(Bestellnummer.class);
        INSTANCE.register(Kundennummer.class);
        INSTANCE.register(Rechnungsmonat.class);
        INSTANCE.register(Rechnungsnummer.class);
        INSTANCE.register(Referenznummer.class);
        INSTANCE.register(SteuerIdNr.class);
        INSTANCE.register(Steuernummer.class);
        INSTANCE.register(UStIdNr.class);
        INSTANCE.register(PackedDecimal.class);
        INSTANCE.register(Bruch.class);
    }
}

