/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.pruefung.NumberValidator;
import org.apache.commons.lang3.StringUtils;

public class BLZ
extends AbstractFachwert<String> {
    public BLZ(String code) {
        super(BLZ.validate(code));
    }

    public BLZ(int code) {
        this(Integer.toString(code));
    }

    public static int validate(int blz) {
        BLZ.validate(Integer.toString(blz));
        return blz;
    }

    public static String validate(String blz) {
        String normalized = StringUtils.replaceAll((String)blz, (String)"\\s", (String)"");
        return new NumberValidator(100L, 99999999L).validate(normalized);
    }

    public String getUnformatted() {
        return (String)this.getCode();
    }

    public String getFormatted() {
        String input = this.getUnformatted() + "   ";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.getUnformatted().length(); i += 3) {
            buf.append(input.substring(i, i + 3));
            buf.append(' ');
        }
        return buf.toString().trim();
    }
}

