/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.Fachwert;
import de.jfachwert.bank.BIC;
import de.jfachwert.bank.IBAN;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Bankverbindung
implements Fachwert {
    private final String kontoinhaber;
    private final IBAN iban;
    private final BIC bic;

    public Bankverbindung(String bankverbindung) {
        this(Bankverbindung.split(bankverbindung));
    }

    private Bankverbindung(Object[] bankverbindung) {
        this(bankverbindung[0].toString(), (IBAN)bankverbindung[1], (BIC)bankverbindung[2]);
    }

    public Bankverbindung(String name, IBAN iban) {
        this(name, iban, null);
    }

    public Bankverbindung(String name, IBAN iban, BIC bic) {
        this.kontoinhaber = name;
        this.iban = iban;
        this.bic = bic;
    }

    private static Object[] split(String bankverbindung) {
        String[] splitted = new String[3];
        splitted[0] = Bankverbindung.stripSeparator(StringUtils.substringBefore((String)bankverbindung, (String)"IBAN"));
        splitted[1] = Bankverbindung.stripSeparator(StringUtils.substringAfter((String)bankverbindung, (String)"IBAN"));
        if (StringUtils.isBlank((CharSequence)splitted[1])) {
            throw new InvalidValueException((Serializable)((Object)bankverbindung), "bank_account");
        }
        if (splitted[1].contains("BIC")) {
            splitted[2] = Bankverbindung.stripSeparator(StringUtils.substringAfter((String)splitted[1], (String)"BIC"));
            splitted[1] = Bankverbindung.stripSeparator(StringUtils.substringBefore((String)splitted[1], (String)"BIC"));
        } else {
            splitted[2] = "";
        }
        Object[] values = new Object[]{splitted[0], new IBAN(splitted[1]), splitted[2].isEmpty() ? null : new BIC(splitted[2])};
        return values;
    }

    private static String stripSeparator(String raw) {
        String value = raw.trim();
        if (value.endsWith(",")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public String getKontoinhaber() {
        return this.kontoinhaber;
    }

    public IBAN getIban() {
        return this.iban;
    }

    public Optional<BIC> getBic() {
        return this.bic == null ? Optional.empty() : Optional.of(this.bic);
    }

    public int hashCode() {
        return this.iban.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bankverbindung)) {
            return false;
        }
        Bankverbindung other = (Bankverbindung)obj;
        return this.iban.equals(other.iban) && Objects.equals(this.bic, other.bic);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getKontoinhaber());
        buf.append(", IBAN ");
        buf.append(this.getIban());
        if (this.getBic().isPresent()) {
            buf.append(", BIC ");
            buf.append(this.getBic().get());
        }
        return buf.toString();
    }
}

