/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.bank.BLZ;
import de.jfachwert.bank.Kontonummer;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod97Verfahren;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class IBAN
extends AbstractFachwert<String> {
    private static final PruefzifferVerfahren<String> MOD97 = Mod97Verfahren.getInstance();
    public static final IBAN UNBEKANNT = new IBAN("DE07123412341234123412");

    public IBAN(String iban) {
        this(iban, MOD97);
    }

    public IBAN(String iban, PruefzifferVerfahren<String> pzVerfahren) {
        super(IBAN.validate(iban, pzVerfahren));
    }

    public static String validate(String iban) {
        return IBAN.validate(iban, MOD97);
    }

    private static String validate(String iban, PruefzifferVerfahren<String> pzVerfahren) {
        String normalized = StringUtils.remove((String)iban, (char)' ').toUpperCase();
        LengthValidator.validate(normalized, 16, 34);
        switch (normalized.substring(0, 1)) {
            case "AT": {
                LengthValidator.validate(iban, 20);
                break;
            }
            case "CH": {
                LengthValidator.validate(iban, 21);
                break;
            }
            case "DE": {
                LengthValidator.validate(iban, 22);
            }
        }
        return pzVerfahren.validate(normalized);
    }

    public String getFormatted() {
        String input = this.getUnformatted() + "   ";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.getUnformatted().length(); i += 4) {
            buf.append(input.substring(i, i + 4));
            buf.append(' ');
        }
        return buf.toString().trim();
    }

    public String getUnformatted() {
        return (String)this.getCode();
    }

    public Locale getLand() {
        String country = this.getUnformatted().substring(0, 2);
        String language = country.toLowerCase();
        switch (country) {
            case "AT": 
            case "CH": {
                language = "de";
            }
        }
        return new Locale(language, country);
    }

    public String getPruefziffer() {
        return MOD97.getPruefziffer(this.getUnformatted());
    }

    public BLZ getBLZ() {
        String iban = this.getUnformatted();
        return new BLZ(iban.substring(4, 12));
    }

    public Kontonummer getKontonummer() {
        String iban = this.getUnformatted();
        return new Kontonummer(iban.substring(12));
    }
}

