/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.pruefung.exception.IllegalLengthException;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class Kontonummer
extends AbstractFachwert<Long> {
    public Kontonummer(String nr) {
        this(Long.valueOf(Kontonummer.validate(nr)));
    }

    public Kontonummer(long nr) {
        super(Kontonummer.validate(nr));
    }

    public static String validate(String kontonr) {
        String normalized = StringUtils.trimToEmpty((String)kontonr);
        try {
            Kontonummer.validate(Long.valueOf(normalized));
        }
        catch (NumberFormatException nfe) {
            throw new InvalidValueException((Serializable)((Object)kontonr), "account_number", nfe);
        }
        return normalized;
    }

    public static long validate(long kontonr) {
        if (kontonr < 1L) {
            throw new InvalidValueException(Long.valueOf(kontonr), "account_number");
        }
        if (kontonr > 9999999999L) {
            throw new IllegalLengthException(Long.toString(kontonr), 1, 10);
        }
        return kontonr;
    }

    @Override
    public String toString() {
        return String.format("%010d", this.getCode());
    }
}

