/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.Fachwert;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class Bruch
implements Fachwert {
    private final BigInteger zaehler;
    private final BigInteger nenner;

    public Bruch(String bruch) {
        this(Bruch.toNumbers(bruch));
    }

    private static BigInteger[] toNumbers(String bruch) {
        String[] parts = StringUtils.split((String)bruch, (String)"/");
        if (parts.length != 2) {
            throw new InvalidValueException((Serializable)((Object)bruch), "fraction");
        }
        BigInteger[] numbers = new BigInteger[]{new BigInteger(parts[0]), new BigInteger(parts[1])};
        return numbers;
    }

    private Bruch(BigInteger[] number) {
        this(number[0], number[1]);
    }

    public Bruch(long zaehler, long nenner) {
        this(BigInteger.valueOf(zaehler), BigInteger.valueOf(nenner));
    }

    public Bruch(BigInteger zaehler, BigInteger nenner) {
        this.zaehler = zaehler;
        this.nenner = nenner;
    }

    public static Bruch of(String bruch) {
        return new Bruch(bruch);
    }

    public static Bruch of(long zaehler, long nenner) {
        return new Bruch(zaehler, nenner);
    }

    public static Bruch of(BigInteger zaehler, BigInteger nenner) {
        return new Bruch(zaehler, nenner);
    }

    public BigInteger getZaehler() {
        return this.zaehler;
    }

    public BigInteger getNenner() {
        return this.nenner;
    }

    public Bruch kuerzen() {
        BigInteger z = this.getZaehler();
        BigInteger n = this.getNenner();
        BigInteger teiler = BigInteger.valueOf(2L);
        while (teiler.compareTo(n) < 0) {
            while (z.mod(teiler).equals(BigInteger.ZERO) && n.mod(teiler).equals(BigInteger.ZERO)) {
                z = z.divide(teiler);
                n = n.divide(teiler);
            }
            teiler = teiler.add(BigInteger.ONE);
        }
        return Bruch.of(z, n);
    }

    public Bruch kehrwert() {
        return Bruch.of(this.getNenner(), this.getZaehler());
    }

    public Bruch negate() {
        return Bruch.of(this.getZaehler().negate(), this.getNenner());
    }

    public Bruch multiply(Bruch operand) {
        BigInteger z = this.getZaehler().multiply(operand.getZaehler());
        BigInteger n = this.getNenner().multiply(operand.getNenner());
        return Bruch.of(z, n).kuerzen();
    }

    public Bruch divide(Bruch operand) {
        return this.multiply(operand.kehrwert());
    }

    public Bruch add(Bruch operand) {
        BigInteger n = this.getNenner().multiply(operand.getNenner());
        BigInteger z1 = this.getZaehler().multiply(operand.getNenner());
        BigInteger z2 = operand.getZaehler().multiply(this.getNenner());
        return Bruch.of(z1.add(z2), n).kuerzen();
    }

    public Bruch subtract(Bruch operand) {
        return this.add(operand.negate());
    }

    public String toString() {
        return this.getZaehler() + "/" + this.getNenner();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bruch)) {
            return false;
        }
        Bruch other = ((Bruch)obj).kuerzen();
        Bruch gekuerzt = this.kuerzen();
        return gekuerzt.getZaehler().equals(other.getZaehler()) && gekuerzt.getNenner().equals(other.getNenner());
    }

    public int hashCode() {
        return this.kuerzen().toString().hashCode();
    }
}

