/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.Fachwert;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

public class Nummer
implements Fachwert {
    private final String code;

    public Nummer(long code) {
        this(BigInteger.valueOf(code));
    }

    public Nummer(String code) {
        this.code = code;
    }

    public Nummer(BigInteger code) {
        this(code.toString());
    }

    public static String validate(String nummer) {
        try {
            return new BigInteger(nummer).toString();
        }
        catch (NumberFormatException nfe) {
            throw new InvalidValueException((Serializable)((Object)nummer), "number");
        }
    }

    public int intValue() {
        return Integer.parseInt(this.code);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Nummer)) {
            return false;
        }
        Nummer other = (Nummer)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public String toString() {
        return this.code.toString();
    }
}

