/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.Fachwert;
import de.jfachwert.SimpleValidator;
import de.jfachwert.math.Bruch;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;

public class PackedDecimal
implements Fachwert {
    private static final NullValidator VALIDATOR = new NullValidator();
    private static final PackedDecimal[] cache = new PackedDecimal[11];
    private final byte[] code;
    public static final PackedDecimal EMPTY;
    public static final PackedDecimal ZERO;
    public static final PackedDecimal ONE;
    public static final PackedDecimal TEN;

    public PackedDecimal(long zahl) {
        this(Long.toString(zahl));
    }

    public PackedDecimal(double zahl) {
        this(Double.toString(zahl));
    }

    public PackedDecimal(BigDecimal zahl) {
        this(zahl.toString());
    }

    public PackedDecimal(String zahl) {
        this(zahl, VALIDATOR);
    }

    public PackedDecimal(String zahl, SimpleValidator<String> validator) {
        this.code = PackedDecimal.asNibbles(validator.validate(zahl));
    }

    public static PackedDecimal valueOf(long zahl) {
        return PackedDecimal.valueOf(Long.toString(zahl));
    }

    public static PackedDecimal valueOf(double zahl) {
        return PackedDecimal.valueOf(Double.toString(zahl));
    }

    public static PackedDecimal valueOf(BigDecimal zahl) {
        return PackedDecimal.valueOf(zahl.toString());
    }

    public static PackedDecimal valueOf(String zahl) {
        String trimmed = StringUtils.trimToEmpty((String)zahl);
        if (StringUtils.isEmpty((CharSequence)trimmed)) {
            return EMPTY;
        }
        if (trimmed.length() == 1 && Character.isDigit(trimmed.charAt(0))) {
            return cache[Character.getNumericValue(trimmed.charAt(0))];
        }
        return new PackedDecimal(zahl);
    }

    public boolean isBruch() {
        return this.toString().contains("/");
    }

    public Bruch toBruch() {
        return Bruch.of(this.toString());
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }

    public PackedDecimal add(PackedDecimal summand) {
        return this.add(summand.toBigDecimal());
    }

    public PackedDecimal add(BigDecimal summand) {
        BigDecimal summe = this.toBigDecimal().add(summand);
        return PackedDecimal.valueOf(summe);
    }

    public PackedDecimal subtract(PackedDecimal operand) {
        return this.subtract(operand.toBigDecimal());
    }

    public PackedDecimal subtract(BigDecimal operand) {
        BigDecimal result = this.toBigDecimal().subtract(operand);
        return PackedDecimal.valueOf(result);
    }

    public PackedDecimal multiply(PackedDecimal operand) {
        return this.multiply(operand.toBigDecimal());
    }

    public PackedDecimal multiply(BigDecimal operand) {
        BigDecimal produkt = this.toBigDecimal().multiply(operand);
        return PackedDecimal.valueOf(produkt);
    }

    public PackedDecimal divide(PackedDecimal operand) {
        return this.divide(operand.toBigDecimal());
    }

    public PackedDecimal divide(BigDecimal operand) {
        BigDecimal result = this.toBigDecimal().divide(operand, RoundingMode.HALF_UP);
        return PackedDecimal.valueOf(result);
    }

    public PackedDecimal movePointLeft(int n) {
        BigDecimal result = this.toBigDecimal().movePointLeft(n);
        return PackedDecimal.valueOf(result);
    }

    public PackedDecimal movePointRight(int n) {
        BigDecimal result = this.toBigDecimal().movePointRight(n);
        return PackedDecimal.valueOf(result);
    }

    public PackedDecimal setScale(int n, RoundingMode mode) {
        BigDecimal result = this.toBigDecimal().setScale(n, mode);
        return PackedDecimal.valueOf(result);
    }

    private static byte[] asNibbles(String zahl) {
        char[] chars = (zahl + " ").toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        try {
            for (int i = 0; i < bytes.length; ++i) {
                int upper = PackedDecimal.decode(chars[i * 2]);
                int lower = PackedDecimal.decode(chars[i * 2 + 1]);
                bytes[i] = (byte)(upper << 4 | lower);
            }
        }
        catch (ValidationException ex) {
            throw new InvalidValueException((Serializable)((Object)zahl), "number");
        }
        return bytes;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (byte b : this.code) {
            buf.append(PackedDecimal.encode(b >> 4));
            buf.append(PackedDecimal.encode(b & 0xF));
        }
        return buf.toString().trim();
    }

    private static int decode(char x) {
        switch (x) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '/': {
                return 10;
            }
            case '\t': 
            case ' ': {
                return 11;
            }
            case '+': {
                return 12;
            }
            case '-': {
                return 13;
            }
            case '.': {
                return 14;
            }
            case ',': {
                return 15;
            }
        }
        throw new InvalidValueException(Character.valueOf(x), "number");
    }

    private static char encode(int nibble) {
        switch (0xF & nibble) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '/';
            }
            case 11: {
                return ' ';
            }
            case 12: {
                return '+';
            }
            case 13: {
                return '-';
            }
            case 14: {
                return '.';
            }
            case 15: {
                return ',';
            }
        }
        throw new IllegalStateException("internal error");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PackedDecimal && this.toString().equals(obj.toString());
    }

    static {
        for (int i = 0; i < cache.length; ++i) {
            PackedDecimal.cache[i] = new PackedDecimal(i);
        }
        EMPTY = new PackedDecimal("");
        ZERO = cache[0];
        ONE = cache[1];
        TEN = cache[10];
    }
}

