/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import de.jfachwert.Fachwert;
import de.jfachwert.net.ChatDienst;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class ChatAccount
implements Fachwert {
    private final ChatDienst chatDienst;
    private final String dienstName;
    private final String account;

    public ChatAccount(String chatAccount) {
        this(ChatAccount.split(chatAccount));
    }

    private ChatAccount(String[] values) {
        this(ChatDienst.toChatDienst(values[0]), values[0], values[1]);
    }

    public ChatAccount(String dienst, String account) {
        this(ChatDienst.toChatDienst(dienst), dienst, account);
    }

    public ChatAccount(ChatDienst dienst, String account) {
        this(dienst, null, account);
    }

    public ChatAccount(ChatDienst chatDienst, String dienstName, String account) {
        this.chatDienst = chatDienst;
        this.dienstName = dienstName;
        this.account = chatDienst.getValidator().validate(account);
    }

    private static String[] split(String value) {
        String[] splitted = StringUtils.trimToEmpty((String)value).split(":\\s+");
        if (splitted.length != 2) {
            throw new InvalidValueException((Serializable)((Object)value), "chat_service");
        }
        return splitted;
    }

    public ChatDienst getChatDienst() {
        return this.chatDienst;
    }

    public String getDienstName() {
        if (this.chatDienst == ChatDienst.SONSTIGER) {
            return this.dienstName;
        }
        return this.chatDienst.toString();
    }

    public String getAccount() {
        return this.account;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChatAccount)) {
            return false;
        }
        ChatAccount other = (ChatAccount)obj;
        return this.dienstName.equalsIgnoreCase(other.dienstName) && this.account.equalsIgnoreCase(other.account);
    }

    public int hashCode() {
        return this.account.hashCode();
    }

    public String toString() {
        return this.getDienstName() + ": " + this.getAccount();
    }
}

