/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import de.jfachwert.SimpleValidator;
import de.jfachwert.pruefung.EMailValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.NumberValidator;
import java.math.BigDecimal;

public enum ChatDienst {
    AIM("AIM"),
    GOOGLE_HANGOUT("Google Hangout"),
    ICQ("ICQ", new NumberValidator(BigDecimal.valueOf(10000L), NumberValidator.INFINITE)),
    JABBER("Jabber", new EMailValidator()),
    SKYPE("Skype"),
    YAHOO("Yahoo"),
    SONSTIGER("sonstiger");

    private final String name;
    private final SimpleValidator validator;

    private ChatDienst(String name) {
        this(name, new NullValidator());
    }

    private ChatDienst(String name, SimpleValidator validator) {
        this.name = name;
        this.validator = validator;
    }

    public SimpleValidator getValidator() {
        return this.validator;
    }

    public String toString() {
        return this.name;
    }

    public static ChatDienst toChatDienst(String dienst) {
        for (ChatDienst cd : ChatDienst.values()) {
            if (!cd.toString().equalsIgnoreCase(dienst)) continue;
            return cd;
        }
        return SONSTIGER;
    }
}

