/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;

public class Domainname
extends AbstractFachwert<String> {
    private static final Pattern VALID_PATTERN = Pattern.compile("^(?=.{1,253}\\.?$)(?:(?!-|[^.]+_)[A-Za-z0-9-_]{1,63}(?<!-)(?:\\.|$))+$");

    public Domainname(String name) {
        super(Domainname.validate(name.trim().toLowerCase()));
    }

    public static String validate(String name) {
        if (VALID_PATTERN.matcher(name).matches()) {
            return name;
        }
        throw new InvalidValueException((Serializable)((Object)name), "name");
    }

    public Domainname getTLD() {
        return new Domainname(StringUtils.substringAfterLast((String)((String)this.getCode()), (String)"."));
    }

    public Domainname getLevelDomain(int level) {
        String[] parts = ((String)this.getCode()).split("\\.");
        int firstPart = parts.length - level;
        if (firstPart < 0 || level < 1) {
            throw new InvalidValueException((Serializable)Integer.valueOf(level), "level", (Range<? extends Comparable>)Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(parts.length)));
        }
        StringBuilder name = new StringBuilder(parts[firstPart]);
        for (int i = firstPart + 1; i < parts.length; ++i) {
            name.append('.');
            name.append(parts[i]);
        }
        return new Domainname(name.toString());
    }
}

