/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.pruefung.TelefonnummerValidator;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Telefonnummer
extends AbstractFachwert<String> {
    private static final TelefonnummerValidator DEFAULT_VALIDATOR = new TelefonnummerValidator();

    public Telefonnummer(String nummer) {
        this(nummer, DEFAULT_VALIDATOR);
    }

    public Telefonnummer(URI uri) {
        this(uri.getSchemeSpecificPart());
    }

    public Telefonnummer(String nummer, TelefonnummerValidator validator) {
        super(Telefonnummer.normalize(validator.validate(nummer)));
    }

    public Telefonnummer getInlandsnummer() {
        if (this.getLaenderkennzahl().isPresent()) {
            String nummer = ((String)this.getCode()).substring(3).trim();
            if (StringUtils.startsWithAny((CharSequence)nummer, (CharSequence[])new CharSequence[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"})) {
                nummer = "0" + nummer;
            }
            return new Telefonnummer(nummer);
        }
        return this;
    }

    public Optional<String> getLaenderkennzahl() {
        String laenderkennzahl = ((String)this.getCode()).substring(0, 3);
        if (laenderkennzahl.startsWith("+")) {
            return Optional.of(laenderkennzahl);
        }
        return Optional.empty();
    }

    public String getVorwahl() {
        String[] parts = ((String)this.getCode()).trim().split("[ /-]|(\\(0\\))");
        String vorwahl = parts[0];
        if (vorwahl.startsWith("+")) {
            String string = vorwahl = StringUtils.isBlank((CharSequence)parts[1]) ? parts[2] : parts[1];
        }
        if ((vorwahl = StringUtils.removeAll((String)vorwahl, (String)"[ \t+-/(\\(\\))]")).startsWith("0")) {
            return vorwahl;
        }
        return "0" + vorwahl;
    }

    public Telefonnummer getRufnummer() {
        String inlandsnummer = StringUtils.replaceAll((String)this.getInlandsnummer().toString(), (String)"[ /]+", (String)" ");
        return new Telefonnummer(StringUtils.substringAfter((String)inlandsnummer, (String)" ").replaceAll(" ", ""));
    }

    @Override
    public int hashCode() {
        return this.toShortString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Telefonnummer)) {
            return false;
        }
        Telefonnummer other = (Telefonnummer)obj;
        return this.toShortString().equals(other.toShortString());
    }

    public String toShortString() {
        return StringUtils.removeAll((String)((String)this.getCode()), (String)"[ \t+-/]|(\\(0\\))");
    }

    public String toDinString() {
        Optional<String> laenderkennzahl = this.getLaenderkennzahl();
        return laenderkennzahl.map(s -> s + " " + this.getVorwahl().substring(1) + " " + this.getRufnummer()).orElseGet(() -> this.getVorwahl() + " " + this.getRufnummer());
    }

    public String toE123String() {
        if (this.getLaenderkennzahl().isPresent()) {
            return this.toDinString().replace('-', ' ');
        }
        return "(" + this.getVorwahl() + ") " + this.getRufnummer().toString().replace('-', ' ');
    }

    public URI toURI() {
        return URI.create("tel:" + this.toDinString().replace(' ', '-'));
    }

    private static String normalize(String nummer) {
        String normalized = nummer.trim();
        if (normalized.startsWith("(0)")) {
            normalized = "0" + normalized.substring(3);
        }
        return normalized;
    }
}

