/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import de.jfachwert.Fachwert;
import de.jfachwert.post.Ort;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;

public class Adresse
implements Fachwert {
    private static final Logger LOG = Logger.getLogger(Adresse.class.getName());
    private final Ort ort;
    private final String strasse;
    private final String hausnummer;

    public Adresse(String adresse) {
        this(Adresse.split(adresse));
    }

    private Adresse(String[] adresse) {
        this(new Ort(adresse[0]), adresse[1], adresse[2]);
    }

    public Adresse(Ort ort, String strasse, String hausnummer) {
        this.ort = ort;
        this.strasse = strasse;
        this.hausnummer = hausnummer;
        Adresse.validate(ort, strasse, hausnummer);
    }

    public static void validate(Ort ort, String strasse, String hausnummer) {
        if (!ort.getPLZ().isPresent()) {
            throw new InvalidValueException(ort, "postal_code");
        }
        if (StringUtils.isBlank((CharSequence)strasse)) {
            throw new InvalidValueException((Serializable)((Object)strasse), "street");
        }
        if (StringUtils.isBlank((CharSequence)hausnummer)) {
            throw new InvalidValueException((Serializable)((Object)hausnummer), "house_number");
        }
        if (Character.isDigit(strasse.trim().charAt(0)) && Character.isLetter(hausnummer.trim().charAt(0)) && strasse.length() < hausnummer.length()) {
            throw new InvalidValueException((Serializable)((Object)(strasse + " " + hausnummer)), "values_exchanged");
        }
    }

    public static void validate(String adresse) {
        String[] splitted = Adresse.split(adresse);
        Ort ort = new Ort(splitted[0]);
        Adresse.validate(ort, splitted[1], splitted[2]);
    }

    private static String[] split(String adresse) {
        String[] lines = StringUtils.trimToEmpty((String)adresse).split("[,\\n$]");
        if (lines.length != 2) {
            throw new InvalidValueException((Serializable)((Object)adresse), "address");
        }
        ArrayList<String> splitted = new ArrayList<String>();
        if (Adresse.hasPLZ(lines[0])) {
            splitted.add(lines[0].trim());
            splitted.addAll(Adresse.toStrasseHausnummer(lines[1]));
        } else {
            splitted.add(lines[1].trim());
            splitted.addAll(Adresse.toStrasseHausnummer(lines[0]));
        }
        return splitted.toArray(new String[3]);
    }

    private static boolean hasPLZ(String line) {
        try {
            Ort ort = new Ort(line);
            return ort.getPLZ().isPresent();
        }
        catch (ValidationException ex) {
            LOG.log(Level.FINE, "no PLZ inside '" + line + "' found:", ex);
            return false;
        }
    }

    private static List<String> toStrasseHausnummer(String line) {
        String[] splitted = line.trim().split("\\s+");
        if (splitted.length != 2) {
            splitted = line.split("\\s+[0-9]", 2);
            splitted[1] = line.substring(splitted[0].length()).trim();
        }
        if (splitted.length != 2) {
            throw new InvalidValueException((Serializable)((Object)line), "street_or_house_number");
        }
        return Arrays.asList(splitted);
    }

    public Ort getOrt() {
        return this.ort;
    }

    public PLZ getPLZ() {
        return this.ort.getPLZ().get();
    }

    public String getStrasse() {
        return this.strasse;
    }

    public String getHausnummer() {
        return this.hausnummer;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Adresse)) {
            return false;
        }
        Adresse other = (Adresse)obj;
        return this.ort.equals(other.ort) && this.strasse.equalsIgnoreCase(other.strasse) && this.hausnummer.equalsIgnoreCase(other.hausnummer);
    }

    public int hashCode() {
        return this.ort.hashCode() + this.strasse.hashCode() + this.hausnummer.hashCode();
    }

    public String toString() {
        return this.getOrt() + ", " + this.getStrasse() + " " + this.getHausnummer();
    }
}

