/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import de.jfachwert.Fachwert;
import de.jfachwert.post.Adressat;
import de.jfachwert.post.Adresse;
import de.jfachwert.post.Postfach;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;

public class Anschrift
implements Fachwert {
    private static final Logger LOG = Logger.getLogger(Anschrift.class.getName());
    public static final String ADDRESS = "address";
    private final Adressat adressat;
    private final Adresse adresse;
    private final Postfach postfach;

    public Anschrift(String anschrift) {
        this(Anschrift.split(anschrift));
    }

    private Anschrift(Object[] anschrift) {
        this(new Adressat(anschrift[0].toString()), (Adresse)anschrift[1], (Postfach)anschrift[2]);
    }

    public Anschrift(String name, Adresse adresse) {
        this(new Adressat(name), adresse);
        Anschrift.validate(name, adresse);
    }

    public Anschrift(Adressat name, Adresse adresse) {
        this(name, adresse, null);
    }

    public Anschrift(String name, Postfach postfach) {
        this(new Adressat(name), postfach);
        Anschrift.validate(name, postfach);
    }

    public Anschrift(Adressat name, Postfach postfach) {
        this(name, null, postfach);
    }

    private Anschrift(Adressat name, Adresse adresse, Postfach postfach) {
        this.adressat = name;
        this.adresse = adresse;
        this.postfach = postfach;
        if (adresse == null) {
            if (postfach == null) {
                throw new InvalidValueException(postfach, "post_office_box");
            }
        } else if (postfach != null) {
            throw new InvalidValueException(adresse, ADDRESS);
        }
    }

    public static void validate(String anschrift) {
        Anschrift.split(anschrift);
    }

    private static Object[] split(String anschrift) {
        String[] lines = StringUtils.trimToEmpty((String)anschrift).split("[,\\n$]");
        if (lines.length < 2) {
            throw new InvalidValueException((Serializable)((Object)anschrift), ADDRESS);
        }
        Object[] parts = new Object[3];
        parts[0] = new Adressat(lines[0]);
        String adresseOrPostfach = anschrift.substring(lines[0].length() + 1).trim();
        try {
            parts[1] = null;
            parts[2] = new Postfach(adresseOrPostfach);
        }
        catch (ValidationException ex) {
            LOG.log(Level.FINE, "'" + adresseOrPostfach + "' is not a post office box:", ex);
            parts[1] = new Adresse(adresseOrPostfach);
            parts[2] = null;
        }
        return parts;
    }

    public static void validate(String name, Adresse adresse) {
        Anschrift.validateName(name);
        if (adresse == null) {
            throw new InvalidValueException(ADDRESS);
        }
    }

    public static void validate(String name, Postfach postfach) {
        Anschrift.validateName(name);
        if (postfach == null) {
            throw new InvalidValueException("post_office_box");
        }
    }

    private static void validateName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new InvalidValueException((Serializable)((Object)name), "name");
        }
    }

    public Adressat getAdressat() {
        return this.adressat;
    }

    public String getName() {
        return this.adressat.getName();
    }

    public Adresse getAdresse() {
        if (this.adresse == null) {
            throw new IllegalStateException("no address available");
        }
        return this.adresse;
    }

    public Postfach getPostfach() {
        if (this.postfach == null) {
            throw new IllegalStateException("no post office box available");
        }
        return this.postfach;
    }

    public boolean hasPostfach() {
        return this.postfach != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Anschrift)) {
            return false;
        }
        Anschrift other = (Anschrift)obj;
        return this.getName().equalsIgnoreCase(other.getName()) && this.getAdresse().equals(other.getAdresse());
    }

    public int hashCode() {
        return this.adressat.hashCode();
    }

    public String toString() {
        return this.getName() + ", " + (this.hasPostfach() ? this.getPostfach() : this.getAdresse());
    }
}

