/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import de.jfachwert.Fachwert;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.LengthValidator;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;

public class Ort
implements Fachwert {
    private static final Logger LOG = Logger.getLogger(Ort.class.getName());
    private final String name;
    private final PLZ plz;

    public Ort(String name) {
        this(Ort.split(name));
    }

    private Ort(String[] values) {
        this(values[0].isEmpty() ? null : new PLZ(values[0]), values[1]);
    }

    public Ort(PLZ plz, String name) {
        this.plz = plz;
        this.name = Ort.validate(name);
    }

    public static String validate(String name) {
        String[] splitted = Ort.split(name);
        String ortsname = splitted[1];
        LengthValidator.validate(ortsname, 1, Integer.MAX_VALUE);
        return name;
    }

    private static String[] split(String name) {
        String input = StringUtils.trimToEmpty((String)name);
        String[] splitted = new String[]{"", input};
        if (input.contains(" ")) {
            try {
                String plz;
                splitted[0] = plz = PLZ.validate(StringUtils.substringBefore((String)input, (String)" "));
                splitted[1] = StringUtils.substringAfter((String)input, (String)" ").trim();
            }
            catch (ValidationException ex) {
                LOG.log(Level.FINE, "no PLZ inside '" + name + "' found:", ex);
            }
        }
        return splitted;
    }

    public String getName() {
        return this.name;
    }

    public Optional<PLZ> getPLZ() {
        if (this.plz == null) {
            return Optional.empty();
        }
        return Optional.of(this.plz);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ort)) {
            return false;
        }
        Ort other = (Ort)obj;
        return Objects.equals(this.plz, other.plz) && this.name.equalsIgnoreCase(other.name);
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public String toString() {
        if (this.plz == null) {
            return this.getName();
        }
        return this.plz + " " + this.getName();
    }
}

