/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NumberValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class PLZ
extends AbstractFachwert<String> {
    public PLZ(String plz) {
        super(PLZ.validate(plz));
    }

    public PLZ(String landeskennung, String plz) {
        this(landeskennung + plz);
    }

    public PLZ(Locale land, String plz) {
        this(PLZ.toLandeskennung(land) + plz);
    }

    private static String toLandeskennung(Locale locale) {
        String country;
        switch (country = locale.getCountry().toUpperCase()) {
            case "AT": 
            case "DE": {
                return country.substring(0, 1);
            }
        }
        return country;
    }

    public static String validate(String code) {
        String plz = PLZ.normalize(code);
        if (PLZ.hasLandeskennung(plz)) {
            PLZ.validateNumberOf(plz);
        } else {
            plz = LengthValidator.validate(plz, 3, 10);
        }
        return plz;
    }

    private static void validateNumberOf(String plz) {
        String kennung = PLZ.getLandeskennung(plz);
        String zahl = PLZ.getPostleitZahl(plz);
        switch (kennung) {
            case "CH": 
            case "D": {
                PLZ.validateNumberWith(plz, 6, zahl);
                break;
            }
            case "A": {
                PLZ.validateNumberWith(plz, 5, zahl);
                break;
            }
            default: {
                LengthValidator.validate(zahl, 3, 10);
            }
        }
    }

    private static void validateNumberWith(String plz, int length, String zahl) {
        LengthValidator.validate(plz, length);
        new NumberValidator(BigDecimal.ZERO, BigDecimal.TEN.pow(length)).validate(zahl);
    }

    private static String normalize(String plz) {
        return StringUtils.replaceChars((String)plz, (String)" -", (String)"").toUpperCase();
    }

    public boolean hasLandeskennung() {
        return PLZ.hasLandeskennung((String)this.getCode());
    }

    private static boolean hasLandeskennung(String plz) {
        char kennung = plz.charAt(0);
        return Character.isLetter(kennung);
    }

    public String getLandeskennung() {
        if (!this.hasLandeskennung()) {
            throw new IllegalStateException("keine Landeskennung angegeben");
        }
        return PLZ.getLandeskennung((String)this.getCode());
    }

    private static String getLandeskennung(String plz) {
        return StringUtils.substringBefore((String)PLZ.toLongString(plz), (String)"-");
    }

    public Locale getLand() {
        String kennung;
        switch (kennung = this.getLandeskennung()) {
            case "D": {
                return new Locale("de", "DE");
            }
            case "A": {
                return new Locale("de", "AT");
            }
            case "CH": {
                return new Locale("de", "CH");
            }
        }
        throw new UnsupportedOperationException("unbekannte Landeskennung '" + kennung + "'");
    }

    public String getPostleitZahl() {
        return PLZ.getPostleitZahl((String)this.getCode());
    }

    private static String getPostleitZahl(String plz) {
        if (!PLZ.hasLandeskennung(plz)) {
            return plz;
        }
        return StringUtils.substringAfter((String)PLZ.toLongString(plz), (String)"-");
    }

    public String toShortString() {
        return (String)this.getCode();
    }

    public String toLongString() {
        String plz = (String)this.getCode();
        if (this.hasLandeskennung()) {
            plz = PLZ.toLongString(plz);
        }
        return plz;
    }

    private static String toLongString(String plz) {
        int i = StringUtils.indexOfAny((CharSequence)plz, (String)"0123456789");
        if (i < 0) {
            throw new InvalidValueException((Serializable)((Object)plz), "postal_code");
        }
        return plz.substring(0, i) + "-" + plz.substring(i);
    }

    @Override
    public String toString() {
        return this.toLongString();
    }
}

