/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import de.jfachwert.Fachwert;
import de.jfachwert.post.Ort;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Postfach
implements Fachwert {
    private final BigInteger nummer;
    private final Ort ort;

    public Postfach(String postfach) {
        this(Postfach.split(postfach));
    }

    private Postfach(String[] postfach) {
        this(postfach[0], postfach[1]);
    }

    public Postfach(Ort ort) {
        this.ort = ort;
        this.nummer = null;
        Postfach.validate(ort);
    }

    public Postfach(String nummer, String ort) {
        this(Postfach.toNumber(nummer), new Ort(ort));
    }

    public Postfach(long nummer, Ort ort) {
        this(BigInteger.valueOf(nummer), ort);
    }

    public Postfach(BigInteger nummer, Ort ort) {
        this.nummer = nummer;
        this.ort = ort;
        Postfach.validate(nummer, ort);
    }

    public Postfach(Optional<BigInteger> nummer, Ort ort) {
        this.nummer = nummer.orElse(null);
        this.ort = ort;
        if (this.nummer == null) {
            Postfach.validate(ort);
        } else {
            Postfach.validate(nummer.get(), ort);
        }
    }

    public static void validate(String postfach) {
        String[] lines = Postfach.split(postfach);
        Postfach.toNumber(lines[0]);
        Ort ort = new Ort(lines[1]);
        if (!ort.getPLZ().isPresent()) {
            throw new InvalidValueException((Serializable)((Object)postfach), "postal_code");
        }
    }

    private static String[] split(String postfach) {
        String[] lines = StringUtils.trimToEmpty((String)postfach).split("[,\\n$]");
        String[] splitted = new String[]{"", lines[0]};
        if (lines.length == 2) {
            splitted = lines;
        } else if (lines.length > 2) {
            throw new InvalidValueException((Serializable)((Object)postfach), "post_office_box");
        }
        return splitted;
    }

    private static Optional<BigInteger> toNumber(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return Optional.empty();
        }
        String unformatted = StringUtils.replaceAll((String)number, (String)"Postfach|\\s+", (String)"");
        try {
            return Optional.of(new BigInteger(unformatted));
        }
        catch (NumberFormatException nfe) {
            throw new InvalidValueException((Serializable)((Object)number), "number", nfe);
        }
    }

    public static void validate(BigInteger nummer, Ort ort) {
        if (nummer.compareTo(BigInteger.ONE) < 0) {
            throw new InvalidValueException(nummer, "number");
        }
        Postfach.validate(ort);
    }

    public static void validate(Ort ort) {
        if (!ort.getPLZ().isPresent()) {
            throw new InvalidValueException(ort, "postal_code");
        }
    }

    public Optional<BigInteger> getNummer() {
        if (this.nummer == null) {
            return Optional.empty();
        }
        return Optional.of(this.nummer);
    }

    public String getNummerFormatted() {
        if (!this.getNummer().isPresent()) {
            throw new IllegalStateException("no number present");
        }
        BigInteger hundert = BigInteger.valueOf(100L);
        StringBuilder formatted = new StringBuilder();
        BigInteger i = this.getNummer().get();
        while (i.compareTo(BigInteger.ONE) > 0) {
            formatted.insert(0, " " + i.remainder(hundert));
            i = i.divide(hundert);
        }
        return formatted.toString().trim();
    }

    public PLZ getPlz() {
        return this.ort.getPLZ().get();
    }

    public Ort getOrt() {
        return this.ort;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Postfach)) {
            return false;
        }
        Postfach other = (Postfach)obj;
        return this.nummer.equals(other.nummer) && this.ort.equals(other.ort);
    }

    public int hashCode() {
        return this.getOrt().hashCode();
    }

    public String toString() {
        if (this.getNummer().isPresent()) {
            return "Postfach " + this.getNummerFormatted() + ", " + this.getOrt();
        }
        return this.getOrt().toString();
    }
}

