/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.SimpleValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EMailValidator
implements SimpleValidator<String> {
    private final Pattern addressPattern;

    public EMailValidator() {
        this(Pattern.compile("^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"));
    }

    protected EMailValidator(Pattern pattern) {
        this.addressPattern = pattern;
    }

    public String validateAdresse(String emailAdresse) {
        Matcher matcher = this.addressPattern.matcher(emailAdresse);
        if (matcher.matches()) {
            return emailAdresse;
        }
        throw new InvalidValueException((Serializable)((Object)emailAdresse), "email_address");
    }

    @Override
    public String validate(String account) {
        return this.validateAdresse(account);
    }
}

