/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.pruefung.NoopVerfahren;
import de.jfachwert.pruefung.exception.IllegalLengthException;
import java.io.Serializable;
import java.util.Objects;

public class LengthValidator<T extends Serializable>
extends NoopVerfahren<T> {
    public static final PruefzifferVerfahren<String> NOT_EMPTY_VALIDATOR = new LengthValidator<String>(1);
    private final int min;
    private final int max;

    public LengthValidator(int min) {
        this(min, Integer.MAX_VALUE);
    }

    public LengthValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isValid(T wert) {
        int length = Objects.toString(wert, "").length();
        return length >= this.min && length <= this.max;
    }

    @Override
    public T validate(T wert) {
        if (!this.isValid(wert)) {
            throw new IllegalLengthException(Objects.toString(wert), this.min, this.max);
        }
        return wert;
    }

    public static String validate(String value, int expected) {
        if (value.length() != expected) {
            throw new IllegalLengthException(value, expected);
        }
        return value;
    }

    public static String validate(String value, int min, int max) {
        if (min == max) {
            return LengthValidator.validate(value, min);
        }
        if (value.length() < min || value.length() > max) {
            throw new IllegalLengthException(value, min, max);
        }
        return value;
    }
}

