/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.PruefzifferVerfahren;

public class Mod11Verfahren
implements PruefzifferVerfahren<String> {
    private final int anzahlStellen;

    public Mod11Verfahren(int anzahlStellen) {
        this.anzahlStellen = anzahlStellen;
    }

    @Override
    public String getPruefziffer(String wert) {
        return wert.substring(wert.length() - 1);
    }

    @Override
    public boolean isValid(String wert) {
        int n = this.anzahlStellen + 1;
        if (wert.length() != n) {
            throw new IllegalArgumentException("Steuernummer '" + wert + "' ist nicht " + n + " Zeichen lang");
        }
        String pruefziffer = this.getPruefziffer(wert);
        return pruefziffer.equals(this.berechnePruefziffer(wert.substring(0, wert.length() - 1)));
    }

    @Override
    public String berechnePruefziffer(String wert) {
        char[] ziffernfolge = wert.toCharArray();
        int produkt = 10;
        for (int stelle = 1; stelle <= this.anzahlStellen; ++stelle) {
            int summe = (Character.getNumericValue(ziffernfolge[stelle - 1]) + produkt) % 10;
            if (summe == 0) {
                summe = 10;
            }
            produkt = summe * 2 % 11;
        }
        int pruefziffer = 11 - produkt;
        if (pruefziffer == 10) {
            pruefziffer = 0;
        }
        return Integer.toString(pruefziffer);
    }
}

