/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.PruefzifferVerfahren;
import java.math.BigDecimal;

public class Mod97Verfahren
implements PruefzifferVerfahren<String> {
    private static final Mod97Verfahren INSTANCE = new Mod97Verfahren();

    private Mod97Verfahren() {
    }

    public static PruefzifferVerfahren<String> getInstance() {
        return INSTANCE;
    }

    @Override
    public String getPruefziffer(String wert) {
        return wert.substring(2, 4);
    }

    @Override
    public String berechnePruefziffer(String wert) {
        char[] land = wert.substring(0, 2).toUpperCase().toCharArray();
        String umgestellt = wert.substring(4) + Mod97Verfahren.toZahl(land[0]) + Mod97Verfahren.toZahl(land[1]) + "00";
        BigDecimal number = new BigDecimal(umgestellt);
        BigDecimal modulo = number.remainder(BigDecimal.valueOf(97L));
        int ergebnis = 98 - modulo.intValue();
        return String.format("%02d", ergebnis);
    }

    private static int toZahl(char c) {
        return 10 + c - 65;
    }
}

