/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.SimpleValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.lang3.Range;

public class NumberValidator
implements SimpleValidator<String> {
    private final Range<BigDecimal> range;
    public static final BigDecimal INFINITE = BigDecimal.valueOf(Long.MAX_VALUE);

    public NumberValidator(long min, long max) {
        this(BigDecimal.valueOf(min), BigDecimal.valueOf(max));
    }

    public NumberValidator(BigDecimal min, BigDecimal max) {
        this.range = Range.between((Comparable)min, (Comparable)max);
    }

    @Override
    public String validate(String value) {
        try {
            BigDecimal n = new BigDecimal(value);
            if (this.range.contains((Object)n)) {
                return value;
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException((Serializable)((Object)value), "number", ex);
        }
        throw new InvalidValueException((Serializable)((Object)value), "number", this.range);
    }
}

