/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.SimpleValidator;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TelefonnummerValidator
implements SimpleValidator<String> {
    private final Pattern pattern;
    private final LengthValidator<String> lengthValidator = new LengthValidator(3, 15);

    public TelefonnummerValidator() {
        this(Pattern.compile("[0-9-+/ ()]+"));
    }

    protected TelefonnummerValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public String validate(String nummer) {
        Matcher matcher = this.pattern.matcher(nummer);
        if (matcher.matches()) {
            String normalized = StringUtils.removeAll((String)nummer, (String)"[ \t+-/]|(\\(0\\))");
            this.lengthValidator.validate(normalized);
            return nummer;
        }
        throw new InvalidValueException((Serializable)((Object)nummer), "phone_number");
    }
}

