/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung.exception;

import de.jfachwert.pruefung.exception.LocalizedValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IllegalLengthException
extends LocalizedValidationException {
    private final String argument;
    private final int min;
    private final int max;
    private final List<Integer> allowedLengths = new ArrayList<Integer>();

    public IllegalLengthException(String argument, int expected) {
        this(argument, Collections.singletonList(expected));
    }

    public IllegalLengthException(String argument, int min, int max) {
        super("'" + argument + "': length (" + argument.length() + ") is not between " + min + " and " + max);
        this.min = min;
        this.max = max;
        this.argument = argument;
    }

    public IllegalLengthException(String argument, List<Integer> allowedLengths) {
        super("'" + argument + "': " + argument.length() + " is not in allowed lengths " + allowedLengths);
        this.min = 0;
        this.max = 0;
        this.argument = argument;
        this.allowedLengths.addAll(allowedLengths);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.allowedLengths.isEmpty()) {
            return this.getLocalizedMessage("pruefung.illegallength.exception.message.range", this.argument, this.argument.length(), this.min, this.max);
        }
        return this.getLocalizedMessage("pruefung.illegallength.exception.message.values", this.argument, this.argument.length(), this.allowedLengths);
    }
}

