/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung.exception;

import de.jfachwert.pruefung.exception.LocalizedValidationException;
import java.io.Serializable;
import org.apache.commons.lang3.Range;

public class InvalidValueException
extends LocalizedValidationException {
    private final Serializable value;
    private final String context;
    private final Range<? extends Comparable> range;

    public InvalidValueException(String context) {
        super("missing value for " + context.replace('_', ' '));
        this.value = null;
        this.context = context;
        this.range = null;
    }

    public InvalidValueException(Serializable value, String context) {
        super("invalid value for " + context.replace('_', ' ') + ": \"" + value + '\"');
        this.value = value;
        this.context = context;
        this.range = null;
    }

    public InvalidValueException(Serializable value, String context, Throwable cause) {
        super("invalid value for " + context.replace('_', ' ') + ": \"" + value + '\"', cause);
        this.value = value;
        this.context = context;
        this.range = null;
    }

    public InvalidValueException(Serializable value, String context, Range<? extends Comparable> range) {
        super("value for " + context.replace('_', ' ') + " is not in " + range + ": \"" + value + '\"');
        this.value = value;
        this.context = context;
        this.range = range;
    }

    @Override
    public String getLocalizedMessage() {
        String localizedContext = this.getLocalizedString(this.context);
        if (this.value == null) {
            return this.getLocalizedMessage("pruefung.missingvalue.exception.message", localizedContext);
        }
        if (this.range == null) {
            return this.getLocalizedMessage("pruefung.invalidvalue.exception.message", this.value, localizedContext);
        }
        return this.getLocalizedMessage("pruefung.invalidrange.exception.message", this.value, localizedContext, this.range);
    }
}

