/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung.exception;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;

public abstract class LocalizedValidationException
extends ValidationException {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("de.jfachwert.messages");
    private final String key;

    public LocalizedValidationException(String message) {
        super(message);
        this.key = LocalizedValidationException.asKey(message);
    }

    public LocalizedValidationException(String message, Throwable cause) {
        super(message, cause);
        this.key = LocalizedValidationException.asKey(message);
    }

    private static String asKey(String message) {
        return StringUtils.replaceAll((String)message, (String)" ", (String)"_");
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(this.key, new Object[0]);
    }

    protected String getLocalizedMessage(String key, Object ... args) {
        return MessageFormat.format(this.getLocalizedString(key), args);
    }

    protected String getLocalizedString(String key) {
        try {
            return BUNDLE.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }
}

