/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.rechnung;

import de.jfachwert.Fachwert;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;

public class Rechnungsmonat
implements Fachwert {
    private static final Range<Integer> VALID_MONTH_RANGE = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12));
    private static final Range<Integer> VALID_YEAR_RANGE = Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9999));
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private final byte monat;
    private final short jahr;

    public Rechnungsmonat() {
        this(LocalDate.now());
    }

    public Rechnungsmonat(LocalDate date) {
        this(date.getMonthValue(), date.getYear());
    }

    public Rechnungsmonat(String monat) {
        String[] parts = monat.split("/");
        if (parts.length == 2 && Rechnungsmonat.isDigit(parts[0]) && Rechnungsmonat.isDigit(parts[1])) {
            this.monat = (byte)Rechnungsmonat.validate(MONTH, parts[0], VALID_MONTH_RANGE);
            this.jahr = (short)Rechnungsmonat.validate(YEAR, parts[1], VALID_YEAR_RANGE);
        } else {
            LocalDate date = Rechnungsmonat.toLocalDate(monat);
            this.monat = (byte)date.getMonthValue();
            this.jahr = (short)date.getYear();
        }
    }

    public Rechnungsmonat(int monat, int jahr) {
        this(monat + "/" + jahr);
    }

    public Rechnungsmonat(Month monat, int jahr) {
        this(monat.getValue(), jahr);
    }

    private static LocalDate toLocalDate(String monat) {
        String normalized = monat.replaceAll("[/.\\s]", "-");
        String[] parts = monat.split("-");
        if (parts.length == 2) {
            normalized = "1-" + normalized;
        } else if (parts.length != 3) {
            throw new InvalidValueException((Serializable)((Object)monat), MONTH);
        }
        try {
            return LocalDate.parse(normalized);
        }
        catch (DateTimeParseException ex) {
            return Rechnungsmonat.guessLocalDate(normalized, ex);
        }
    }

    private static LocalDate guessLocalDate(String monat, DateTimeParseException ex) {
        String[] datePatterns;
        for (String pattern : datePatterns = new String[]{"d-MMM-yyyy", "d-MM-yyyy", "yyyy-MMM-d", "yyyy-MM-d", "MMM-d-yyyy"}) {
            try {
                return LocalDate.parse(monat, DateTimeFormatter.ofPattern(pattern));
            }
            catch (DateTimeParseException ignored) {
                ex.addSuppressed(new IllegalArgumentException(ignored.getMessage() + " / '" + monat + "' does not match '" + pattern + "'"));
            }
        }
        throw new InvalidValueException((Serializable)((Object)monat), MONTH, ex);
    }

    private static int validate(String context, String value, Range<Integer> range) {
        int number = Integer.parseInt(value);
        if (!range.contains((Object)number)) {
            throw new InvalidValueException((Serializable)((Object)value), context, range);
        }
        return number;
    }

    private static boolean isDigit(String number) {
        return StringUtils.isNumeric((CharSequence)number);
    }

    public int getMonat() {
        return this.monat;
    }

    public int getJahr() {
        return this.jahr;
    }

    public Rechnungsmonat getVormonat() {
        if (this.monat == 1) {
            return new Rechnungsmonat(12, this.jahr - 1);
        }
        return new Rechnungsmonat(this.monat - 1, (int)this.jahr);
    }

    public Rechnungsmonat getFolgemonat() {
        if (this.monat == 12) {
            return new Rechnungsmonat(1, this.jahr + 1);
        }
        return new Rechnungsmonat(this.monat + 1, (int)this.jahr);
    }

    public Rechnungsmonat getVorjahr() {
        return new Rechnungsmonat(this.monat, this.jahr - 1);
    }

    public Rechnungsmonat getFolgejahr() {
        return new Rechnungsmonat(this.monat, this.jahr + 1);
    }

    public LocalDate ersterTag() {
        return LocalDate.of(this.getJahr(), this.getMonat(), 1);
    }

    public LocalDate ersterTag(DayOfWeek wochentag) {
        LocalDate tag = this.ersterTag();
        while (tag.getDayOfWeek() != wochentag) {
            tag = tag.plusDays(1L);
        }
        return tag;
    }

    public LocalDate ersterArbeitstag() {
        LocalDate tag = this.ersterTag();
        switch (tag.getDayOfWeek()) {
            case SATURDAY: {
                return tag.plusDays(2L);
            }
            case SUNDAY: {
                return tag.plusDays(1L);
            }
        }
        return tag;
    }

    public LocalDate letzterTag() {
        return this.getFolgemonat().ersterTag().minusDays(1L);
    }

    public LocalDate letzterTag(DayOfWeek wochentag) {
        LocalDate tag = this.ersterTag();
        while (tag.getDayOfWeek() != wochentag) {
            tag = tag.minusDays(1L);
        }
        return tag;
    }

    public LocalDate letzterArbeitstag() {
        LocalDate tag = this.letzterTag();
        switch (tag.getDayOfWeek()) {
            case SATURDAY: {
                return tag.minusDays(1L);
            }
            case SUNDAY: {
                return tag.minusDays(2L);
            }
        }
        return tag;
    }

    public LocalDate asLocalDate() {
        return this.ersterTag();
    }

    public String format(String pattern) {
        return this.format(pattern, Locale.getDefault());
    }

    public String format(String pattern, Locale locale) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
        return this.asLocalDate().format(formatter);
    }

    public int hashCode() {
        return this.jahr * 12 + this.monat;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rechnungsmonat)) {
            return false;
        }
        Rechnungsmonat other = (Rechnungsmonat)obj;
        return this.monat == other.monat && this.jahr == other.jahr;
    }

    public String toString() {
        return this.getMonat() + "/" + this.getJahr();
    }
}

