/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod11Verfahren;
import de.jfachwert.pruefung.NoopVerfahren;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UStIdNr
extends AbstractFachwert<String> {
    private static final Map<String, PruefzifferVerfahren<String>> PRUEFZIFFER_VERFAHREN = new HashMap<String, PruefzifferVerfahren<String>>();

    public UStIdNr(String nr) {
        this(nr, UStIdNr.selectPruefzifferVerfahrenFor(nr));
    }

    public UStIdNr(String nr, PruefzifferVerfahren<String> pzVerfahren) {
        super(UStIdNr.validate(nr, pzVerfahren));
    }

    private static PruefzifferVerfahren<String> selectPruefzifferVerfahrenFor(String nr) {
        String laenderkuerzel = UStIdNr.toLaenderkuerzel(nr);
        PruefzifferVerfahren<String> verfahren = PRUEFZIFFER_VERFAHREN.get(laenderkuerzel);
        if (verfahren == null) {
            verfahren = new NoopVerfahren<String>();
        }
        return verfahren;
    }

    public static String validate(String nr) {
        return UStIdNr.validate(nr, UStIdNr.selectPruefzifferVerfahrenFor(nr));
    }

    private static String validate(String nr, PruefzifferVerfahren<String> verfahren) {
        String unformatted = StringUtils.remove((String)nr, (char)' ');
        LengthValidator.validate(unformatted, 7, 14);
        verfahren.validate(unformatted.substring(2));
        return unformatted;
    }

    public Locale getLand() {
        return new Locale(UStIdNr.toLaenderkuerzel((String)this.getCode()));
    }

    private static String toLaenderkuerzel(String nr) {
        String kuerzel = nr.substring(0, 2).toUpperCase();
        if (StringUtils.isAlpha((CharSequence)kuerzel)) {
            return kuerzel;
        }
        throw new InvalidValueException((Serializable)((Object)nr), "country");
    }

    static {
        PRUEFZIFFER_VERFAHREN.put("DE", new Mod11Verfahren(8));
    }
}

