/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.bank.BLZ;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.NumberValidator;
import java.io.Serializable;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.RegExUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u000f\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0011"}, d2={"Lde/jfachwert/bank/BLZ;", "Lde/jfachwert/AbstractFachwert;", "Lde/jfachwert/math/PackedDecimal;", "code", "", "(I)V", "", "validator", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "formatted", "getFormatted", "()Ljava/lang/String;", "unformatted", "getUnformatted", "Companion", "Validator", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nBLZ.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BLZ.kt\nde/jfachwert/bank/BLZ\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,170:1\n107#2:171\n79#2,22:172\n*S KotlinDebug\n*F\n+ 1 BLZ.kt\nde/jfachwert/bank/BLZ\n*L\n80#1:171\n80#1:172,22\n*E\n"})
public class BLZ
extends AbstractFachwert<PackedDecimal, BLZ> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final WeakHashMap<String, BLZ> WEAK_CACHE = new WeakHashMap();
    @NotNull
    private static final Validator VALIDATOR = new Validator();
    @JvmField
    @NotNull
    public static final BLZ NULL = new BLZ("", new NullValidator());

    @JvmOverloads
    public BLZ(@NotNull String code, @NotNull KSimpleValidator<PackedDecimal> validator) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super((Serializable)PackedDecimal.Companion.valueOf(code), validator);
    }

    public /* synthetic */ BLZ(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    public BLZ(int code) {
        String string = Integer.toString(code);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this(string, null, 2, null);
    }

    @NotNull
    public final String getUnformatted() {
        return ((PackedDecimal)this.getCode()).toString();
    }

    @NotNull
    public final String getFormatted() {
        String input = this.getUnformatted() + "   ";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.getUnformatted().length(); i += 3) {
            buf.append(input, i, i + 3);
            buf.append(' ');
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @JvmOverloads
    public BLZ(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(code, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String blz) {
        return Companion.validate(blz);
    }

    @JvmStatic
    @NotNull
    public static final BLZ of(int code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final BLZ of(@NotNull String code) {
        return Companion.of(code);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/bank/BLZ$Companion;", "", "()V", "NULL", "Lde/jfachwert/bank/BLZ;", "VALIDATOR", "Lde/jfachwert/bank/BLZ$Validator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "", "of", "code", "", "validate", "blz", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String blz) {
            Intrinsics.checkNotNullParameter((Object)blz, (String)"blz");
            return VALIDATOR.validate(PackedDecimal.Companion.of(blz)).toString();
        }

        @JvmStatic
        @NotNull
        public final BLZ of(int code) {
            String string = Integer.toString(code);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.of(string);
        }

        @JvmStatic
        @NotNull
        public final BLZ of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            BLZ bLZ = WEAK_CACHE.computeIfAbsent(code, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)bLZ, (String)"computeIfAbsent(...)");
            return bLZ;
        }

        private static final BLZ of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (BLZ)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u000e\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u0004\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\n"}, d2={"Lde/jfachwert/bank/BLZ$Validator;", "Lde/jfachwert/KSimpleValidator;", "Lde/jfachwert/math/PackedDecimal;", "()V", "validate", "value", "", "blz", "", "Companion", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<PackedDecimal> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final NumberValidator NUMBER_VALIDATOR = new NumberValidator(100L, 99999999L);

        @Override
        @NotNull
        public PackedDecimal validate(@NotNull PackedDecimal value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String normalized = this.validate(value.toString());
            return PackedDecimal.Companion.of(normalized);
        }

        @Override
        @NotNull
        public final String validate(@Nullable String blz) {
            String normalized = RegExUtils.replaceAll((String)blz, (String)"\\s", (String)"");
            Intrinsics.checkNotNull((Object)normalized);
            return NUMBER_VALIDATOR.validate(normalized);
        }

        @Override
        public final int validate(int blz) {
            this.validate(Integer.toString(blz));
            return blz;
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public PackedDecimal verify(@NotNull PackedDecimal value) {
            return (PackedDecimal)KSimpleValidator.DefaultImpls.verify(this, (Serializable)value);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/jfachwert/bank/BLZ$Validator$Companion;", "", "()V", "NUMBER_VALIDATOR", "Lde/jfachwert/pruefung/NumberValidator;", "jfachwert"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

