/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.bank.BIC;
import de.jfachwert.bank.IBAN;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.util.ToFachwertSerializer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0012\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0017\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nB#\b\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\tH\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lde/jfachwert/bank/Bankverbindung;", "Lde/jfachwert/KFachwert;", "bankverbindung", "", "(Ljava/lang/String;)V", "", "", "([Ljava/lang/Object;)V", "map", "", "(Ljava/util/Map;)V", "kontoinhaber", "iban", "Lde/jfachwert/bank/IBAN;", "bic", "Lde/jfachwert/bank/BIC;", "(Ljava/lang/String;Lde/jfachwert/bank/IBAN;Lde/jfachwert/bank/BIC;)V", "getIban", "()Lde/jfachwert/bank/IBAN;", "getKontoinhaber", "()Ljava/lang/String;", "equals", "", "other", "getBic", "Ljava/util/Optional;", "hashCode", "", "toMap", "toString", "Companion", "jfachwert"})
public class Bankverbindung
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kontoinhaber;
    @NotNull
    private final IBAN iban;
    @Nullable
    private final BIC bic;
    @NotNull
    private static final WeakHashMap<Triple<String, IBAN, BIC>, Bankverbindung> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Bankverbindung NULL = new Bankverbindung("", IBAN.NULL, BIC.NULL);

    @JvmOverloads
    public Bankverbindung(@NotNull String kontoinhaber, @NotNull IBAN iban, @Nullable BIC bic) {
        Intrinsics.checkNotNullParameter((Object)kontoinhaber, (String)"kontoinhaber");
        Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
        this.kontoinhaber = kontoinhaber;
        this.iban = iban;
        this.bic = bic;
    }

    public /* synthetic */ Bankverbindung(String string, IBAN iBAN, BIC bIC, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bIC = null;
        }
        this(string, iBAN, bIC);
    }

    @NotNull
    public final String getKontoinhaber() {
        return this.kontoinhaber;
    }

    @NotNull
    public final IBAN getIban() {
        return this.iban;
    }

    public Bankverbindung(@NotNull String bankverbindung) {
        Intrinsics.checkNotNullParameter((Object)bankverbindung, (String)"bankverbindung");
        this(Bankverbindung.Companion.split(bankverbindung));
    }

    private Bankverbindung(Object[] bankverbindung) {
        String string = String.valueOf(bankverbindung[0]);
        Object object = bankverbindung[1];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.jfachwert.bank.IBAN");
        this(string, (IBAN)object, (BIC)bankverbindung[2]);
    }

    @JsonCreator
    public Bankverbindung(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        String string = Objects.toString(map.get("kontoinhaber"), "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = map.get("iban");
        Intrinsics.checkNotNull((Object)string2);
        IBAN iBAN = new IBAN(string2, null, 2, null);
        String string3 = map.get("bic");
        Intrinsics.checkNotNull((Object)string3);
        this(string, iBAN, new BIC(string3, null, 2, null));
    }

    @NotNull
    public final Optional<BIC> getBic() {
        Optional<BIC> optional;
        if (this.bic == null) {
            Optional optional2 = Optional.empty();
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
        } else {
            Optional<BIC> optional3 = Optional.of(this.bic);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"of(...)");
        }
        return optional;
    }

    public int hashCode() {
        return this.iban.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Bankverbindung)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.iban, (Object)((Bankverbindung)other).iban) && Intrinsics.areEqual((Object)this.bic, (Object)((Bankverbindung)other).bic);
    }

    @NotNull
    public String toString() {
        StringBuilder buf = new StringBuilder(this.kontoinhaber);
        buf.append(", IBAN ");
        buf.append(this.iban);
        if (this.getBic().isPresent()) {
            buf.append(", BIC ");
            buf.append(this.getBic().get());
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Map map = new HashMap();
        map.put("kontoinhaber", this.kontoinhaber);
        map.put("iban", this.iban);
        this.getBic().ifPresent(arg_0 -> Bankverbindung.toMap$lambda$0((Function1)new Function1<BIC, Unit>((Map<String, Object>)map){
            final /* synthetic */ Map<String, Object> $map;
            {
                this.$map = $map;
                super(1);
            }

            public final void invoke(@NotNull BIC b) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.$map.put("bic", b);
            }
        }, arg_0));
        return map;
    }

    @Override
    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid(this);
    }

    @JvmOverloads
    public Bankverbindung(@NotNull String kontoinhaber, @NotNull IBAN iban) {
        Intrinsics.checkNotNullParameter((Object)kontoinhaber, (String)"kontoinhaber");
        Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
        this(kontoinhaber, iban, null, 4, null);
    }

    private static final void toMap$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final Bankverbindung of(@NotNull String s2) {
        return Companion.of(s2);
    }

    @JvmStatic
    @NotNull
    public static final Bankverbindung of(@NotNull String kontoinhaber, @NotNull IBAN iban, @Nullable BIC bic) {
        return Companion.of(kontoinhaber, iban, bic);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0007J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0007J\u001d\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0005\u001a\"\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/jfachwert/bank/Bankverbindung$Companion;", "", "()V", "NULL", "Lde/jfachwert/bank/Bankverbindung;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lkotlin/Triple;", "", "Lde/jfachwert/bank/IBAN;", "Lde/jfachwert/bank/BIC;", "of", "s", "kontoinhaber", "iban", "bic", "split", "", "bankverbindung", "(Ljava/lang/String;)[Ljava/lang/Object;", "stripSeparator", "raw", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nBankverbindung.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bankverbindung.kt\nde/jfachwert/bank/Bankverbindung$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,176:1\n107#2:177\n79#2,22:178\n*S KotlinDebug\n*F\n+ 1 Bankverbindung.kt\nde/jfachwert/bank/Bankverbindung$Companion\n*L\n162#1:177\n162#1:178,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Bankverbindung of(@NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            Bankverbindung b = new Bankverbindung(s2);
            return this.of(b.getKontoinhaber(), b.getIban(), b.bic);
        }

        @JvmStatic
        @NotNull
        public final Bankverbindung of(@NotNull String kontoinhaber, @NotNull IBAN iban, @Nullable BIC bic) {
            Intrinsics.checkNotNullParameter((Object)kontoinhaber, (String)"kontoinhaber");
            Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
            Triple triple = new Triple((Object)kontoinhaber, (Object)iban, (Object)bic);
            Bankverbindung bankverbindung = WEAK_CACHE.computeIfAbsent(triple, arg_0 -> Companion.of$lambda$0((Function1)new Function1<Triple<? extends String, ? extends IBAN, ? extends BIC>, Bankverbindung>(kontoinhaber, iban, bic){
                final /* synthetic */ String $kontoinhaber;
                final /* synthetic */ IBAN $iban;
                final /* synthetic */ BIC $bic;
                {
                    this.$kontoinhaber = $kontoinhaber;
                    this.$iban = $iban;
                    this.$bic = $bic;
                    super(1);
                }

                public final Bankverbindung invoke(Triple<String, ? extends IBAN, ? extends BIC> it) {
                    return new Bankverbindung(this.$kontoinhaber, this.$iban, this.$bic);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)bankverbindung, (String)"computeIfAbsent(...)");
            return bankverbindung;
        }

        public static /* synthetic */ Bankverbindung of$default(Companion companion, String string, IBAN iBAN, BIC bIC, int n, Object object) {
            if ((n & 4) != 0) {
                bIC = null;
            }
            return companion.of(string, iBAN, bIC);
        }

        private final Object[] split(String bankverbindung) {
            BIC bIC;
            String[] splitted = new String[3];
            String string = StringUtils.substringBefore((String)bankverbindung, (String)"IBAN");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substringBefore(...)");
            splitted[0] = this.stripSeparator(string);
            String string2 = StringUtils.substringAfter((String)bankverbindung, (String)"IBAN");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substringAfter(...)");
            splitted[1] = this.stripSeparator(string2);
            if (StringUtils.isBlank((CharSequence)splitted[1])) {
                throw new LocalizedIllegalArgumentException((Serializable)((Object)bankverbindung), "bank_account", null, 4, null);
            }
            String string3 = splitted[1];
            Intrinsics.checkNotNull((Object)string3);
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"BIC", (boolean)false, (int)2, null)) {
                String string4 = StringUtils.substringAfter((String)splitted[1], (String)"BIC");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substringAfter(...)");
                splitted[2] = this.stripSeparator(string4);
                String string5 = StringUtils.substringBefore((String)splitted[1], (String)"BIC");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substringBefore(...)");
                splitted[1] = this.stripSeparator(string5);
            } else {
                splitted[2] = "";
            }
            Object[] values = new Object[3];
            values[0] = splitted[0];
            String string6 = splitted[1];
            Intrinsics.checkNotNull((Object)string6);
            values[1] = new IBAN(string6, null, 2, null);
            String string7 = splitted[2];
            Intrinsics.checkNotNull((Object)string7);
            if (((CharSequence)string7).length() == 0) {
                bIC = null;
            } else {
                String string8 = splitted[2];
                Intrinsics.checkNotNull((Object)string8);
                bIC = new BIC(string8, null, 2, null);
            }
            values[2] = bIC;
            return values;
        }

        private final String stripSeparator(String raw) {
            String value;
            String $this$trim$iv = raw;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.endsWith$default((String)(value = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)",", (boolean)false, (int)2, null)) {
                String string = value.substring(0, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                value = string;
            }
            return value;
        }

        private static final Bankverbindung of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Bankverbindung)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

