/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.bank.Geldbetrag;
import de.jfachwert.pruefung.exception.LocalizedMonetaryException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.NumberValue;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u001aH\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/jfachwert/bank/GeldbetragFactory;", "Ljavax/money/MonetaryAmountFactory;", "Lde/jfachwert/bank/Geldbetrag;", "()V", "context", "Ljavax/money/MonetaryContext;", "kotlin.jvm.PlatformType", "currency", "Ljavax/money/CurrencyUnit;", "number", "", "create", "getAmountType", "Ljava/lang/Class;", "Ljavax/money/MonetaryAmount;", "getDefaultMonetaryContext", "getMaxNumber", "Ljavax/money/NumberValue;", "getMaximalMonetaryContext", "getMinNumber", "getMonetaryContextOf", "setContext", "monetaryContext", "setCurrency", "setNumber", "", "", "Companion", "jfachwert"})
public final class GeldbetragFactory
implements MonetaryAmountFactory<Geldbetrag> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Number number;
    @Nullable
    private CurrencyUnit currency;
    private MonetaryContext context;
    @JvmField
    public static final MonetaryContext MAX_CONTEXT = ((MonetaryContextBuilder)MonetaryContextBuilder.of(Geldbetrag.class).setAmountType(Geldbetrag.class).setPrecision(0).setMaxScale(-1).set((Object)RoundingMode.HALF_UP)).build();

    public GeldbetragFactory() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        this.number = bigDecimal;
        this.context = ((MonetaryContextBuilder)MonetaryContextBuilder.of(Geldbetrag.class).setAmountType(Geldbetrag.class).setPrecision(41).setMaxScale(4).set((Object)RoundingMode.HALF_UP)).build();
    }

    @NotNull
    public Class<? extends MonetaryAmount> getAmountType() {
        return Geldbetrag.class;
    }

    @NotNull
    public GeldbetragFactory setCurrency(@NotNull CurrencyUnit currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        this.currency = currency;
        return this;
    }

    @NotNull
    public GeldbetragFactory setNumber(double number) {
        BigDecimal bigDecimal = BigDecimal.valueOf(number);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.setNumber(bigDecimal);
    }

    @NotNull
    public GeldbetragFactory setNumber(long number) {
        BigDecimal bigDecimal = BigDecimal.valueOf(number);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.setNumber(bigDecimal);
    }

    @NotNull
    public GeldbetragFactory setNumber(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.number = number;
        this.context = this.getMonetaryContextOf(number);
        return this;
    }

    @NotNull
    public final MonetaryContext getMonetaryContextOf(@Nullable Number number) {
        Number value;
        if (number instanceof BigDecimal && ((BigDecimal)(value = number)).scale() > this.context.getMaxScale()) {
            MonetaryContext monetaryContext = ((MonetaryContextBuilder)MonetaryContextBuilder.of(Geldbetrag.class).setAmountType(Geldbetrag.class).setPrecision(this.context.getPrecision()).setMaxScale(((BigDecimal)value).scale()).set((Object)RoundingMode.HALF_UP)).build();
            Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"build(...)");
            return monetaryContext;
        }
        MonetaryContext monetaryContext = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"context");
        return monetaryContext;
    }

    @NotNull
    public NumberValue getMaxNumber() {
        return Geldbetrag.MAX_VALUE.getNumber();
    }

    @NotNull
    public NumberValue getMinNumber() {
        return Geldbetrag.MIN_VALUE.getNumber();
    }

    @NotNull
    public GeldbetragFactory setContext(@NotNull MonetaryContext monetaryContext) {
        Intrinsics.checkNotNullParameter((Object)monetaryContext, (String)"monetaryContext");
        this.context = monetaryContext;
        return this;
    }

    @NotNull
    public Geldbetrag create() {
        if (this.currency == null) {
            Object[] objectArray = new Object[]{this.number};
            throw new LocalizedMonetaryException("currency missing", objectArray);
        }
        CurrencyUnit currencyUnit = this.currency;
        Intrinsics.checkNotNull((Object)currencyUnit);
        MonetaryContext monetaryContext = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"context");
        return Geldbetrag.Companion.valueOf(this.number, currencyUnit, monetaryContext);
    }

    @NotNull
    public MonetaryContext getDefaultMonetaryContext() {
        MonetaryContext monetaryContext = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"context");
        return monetaryContext;
    }

    @NotNull
    public MonetaryContext getMaximalMonetaryContext() {
        MonetaryContext monetaryContext = MAX_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"MAX_CONTEXT");
        return monetaryContext;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/bank/GeldbetragFactory$Companion;", "", "()V", "MAX_CONTEXT", "Ljavax/money/MonetaryContext;", "kotlin.jvm.PlatformType", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

